/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.path;

import java.lang.reflect.Method;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.ScopeType;
import jodd.madvoc.config.ActionDefinition;
import jodd.madvoc.config.ActionNames;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.Scope;
import jodd.madvoc.path.BaseNamingStrategy;
import jodd.util.CharUtil;
import jodd.util.net.HttpMethod;

public class RestActionNamingStrategy
extends BaseNamingStrategy {
    @In
    @Scope(value=ScopeType.CONTEXT)
    protected MadvocConfig madvocConfig;

    @Override
    public ActionDefinition buildActionDef(Class actionClass, Method actionMethod, ActionNames actionNames) {
        String packageActionPath = actionNames.packageActionPath();
        String classActionPath = actionNames.classActionPath();
        String methodActionPath = actionNames.methodActionPath();
        String httpMethod = actionNames.httpMethod();
        if (httpMethod == null) {
            httpMethod = this.resolveHttpMethodFromMethodName(actionMethod.getName());
        }
        String actionPath = classActionPath;
        String resultPath = classActionPath;
        if (this.isAbsolutePath(methodActionPath)) {
            return this.createActionDef(methodActionPath, httpMethod, methodActionPath, actionNames);
        }
        if (methodActionPath != null) {
            if (httpMethod == null && methodActionPath.startsWith(this.madvocConfig.getPathMacroSeparators()[0])) {
                methodActionPath = actionMethod.getName() + "/" + methodActionPath;
            }
            if (!classActionPath.endsWith("/")) {
                actionPath = actionPath + "/";
                resultPath = resultPath + "/";
            }
            actionPath = actionPath + methodActionPath;
            resultPath = httpMethod != null ? resultPath + httpMethod.toLowerCase() : resultPath + actionNames.methodName();
        }
        if (this.isAbsolutePath(actionPath)) {
            return this.createActionDef(actionPath, httpMethod, resultPath, actionNames);
        }
        if (packageActionPath != null) {
            actionPath = packageActionPath + actionPath;
            resultPath = packageActionPath + resultPath;
        } else {
            actionPath = "/" + actionPath;
            resultPath = "/" + resultPath;
        }
        return this.createActionDef(actionPath, httpMethod, resultPath, actionNames);
    }

    protected String resolveHttpMethodFromMethodName(String methodName) {
        int i;
        for (i = 0; i < methodName.length() && !CharUtil.isUppercaseAlpha((char)methodName.charAt(i)); ++i) {
        }
        String name = methodName.substring(0, i).toUpperCase();
        for (HttpMethod httpMethod : HttpMethod.values()) {
            if (!httpMethod.equalsName(name)) continue;
            return httpMethod.name();
        }
        return null;
    }
}

