/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import jodd.io.upload.FileUpload;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.ScopeType;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Outjector;
import jodd.madvoc.injector.Targets;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.MultipartRequestWrapper;
import jodd.util.StringUtil;

public class RequestScopeInjector
implements Injector,
Outjector {
    private static final ScopeType SCOPE_TYPE = ScopeType.REQUEST;
    protected final String encoding;
    protected boolean ignoreEmptyRequestParams;
    protected boolean treatEmptyParamsAsNull;
    protected boolean injectAttributes = true;
    protected boolean injectParameters = true;
    protected boolean encodeGetParams;
    protected boolean ignoreInvalidUploadFiles = true;

    public RequestScopeInjector(MadvocConfig madvocConfig) {
        this.encoding = madvocConfig.getEncoding();
    }

    public void setIgnoreEmptyRequestParams(boolean ignoreEmptyRequestParams) {
        this.ignoreEmptyRequestParams = ignoreEmptyRequestParams;
    }

    public void setTreatEmptyParamsAsNull(boolean treatEmptyParamsAsNull) {
        this.treatEmptyParamsAsNull = treatEmptyParamsAsNull;
    }

    public void setInjectAttributes(boolean injectAttributes) {
        this.injectAttributes = injectAttributes;
    }

    public void setInjectParameters(boolean injectParameters) {
        this.injectParameters = injectParameters;
    }

    public void setEncodeGetParams(boolean encodeGetParams) {
        this.encodeGetParams = encodeGetParams;
    }

    public void setIgnoreInvalidUploadFiles(boolean ignoreInvalidUploadFiles) {
        this.ignoreInvalidUploadFiles = ignoreInvalidUploadFiles;
    }

    protected void injectAttributes(Targets targets, HttpServletRequest servletRequest) {
        Enumeration attributeNames = servletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
                String name = in.matchedPropertyName(attrName);
                if (name != null) {
                    Object attrValue = servletRequest.getAttribute(attrName);
                    target.writeValue(name, attrValue, true);
                }
            });
        }
    }

    protected void injectParameters(Targets targets, HttpServletRequest servletRequest) {
        boolean encode = this.encodeGetParams && servletRequest.getMethod().equals("GET");
        Enumeration paramNames = servletRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
                String name = in.matchedPropertyName(paramName);
                if (name != null) {
                    String[] paramValues = servletRequest.getParameterValues(paramName);
                    if ((paramValues = ServletUtil.prepareParameters((String[])paramValues, (boolean)this.treatEmptyParamsAsNull, (boolean)this.ignoreEmptyRequestParams)) != null) {
                        if (encode) {
                            for (int j = 0; j < paramValues.length; ++j) {
                                String p = paramValues[j];
                                if (p == null) continue;
                                paramValues[j] = StringUtil.convertCharset((String)p, (String)"ISO-8859-1", (String)this.encoding);
                            }
                        }
                        String[] value = paramValues.length != 1 ? paramValues : paramValues[0];
                        target.writeValue(name, value, true);
                    }
                }
            });
        }
    }

    protected void injectUploadedFiles(Targets targets, HttpServletRequest servletRequest) {
        if (!(servletRequest instanceof MultipartRequestWrapper)) {
            return;
        }
        MultipartRequestWrapper multipartRequest = (MultipartRequestWrapper)servletRequest;
        if (!multipartRequest.isMultipart()) {
            return;
        }
        Enumeration paramNames = multipartRequest.getFileParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
                String name = in.matchedPropertyName(paramName);
                if (name != null) {
                    FileUpload paramValues = multipartRequest.getFiles(paramName);
                    if (this.ignoreInvalidUploadFiles) {
                        for (int j = 0; j < ((FileUpload[])paramValues).length; ++j) {
                            FileUpload paramValue = paramValues[j];
                            if (paramValue.isValid() && paramValue.isUploaded()) continue;
                            paramValues[j] = null;
                        }
                    }
                    FileUpload value = ((FileUpload[])paramValues).length == 1 ? paramValues[0] : paramValues;
                    target.writeValue(name, value, true);
                }
            });
        }
    }

    @Override
    public void inject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        if (this.injectAttributes) {
            this.injectAttributes(targets, servletRequest);
        }
        if (this.injectParameters) {
            this.injectParameters(targets, servletRequest);
            this.injectUploadedFiles(targets, servletRequest);
        }
    }

    @Override
    public void outject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        targets.forEachTargetAndOutScopes(SCOPE_TYPE, (target, out) -> {
            Object value = target.readTargetProperty((ScopeData.Out)out);
            servletRequest.setAttribute(out.name, value);
        });
    }
}

