/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.function.Consumer;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.MadvocComponentLifecycle;
import jodd.mutable.MutableInteger;
import jodd.petite.PetiteContainer;
import jodd.props.Props;

public class MadvocContainer {
    public static final String MADVOC_PETITE_CONTAINER_NAME = "madpc";
    private static final Logger log = LoggerFactory.getLogger(MadvocContainer.class);
    private final PetiteContainer madpc = new PetiteContainer();

    public MadvocContainer() {
        this.madpc.addSelf(MADVOC_PETITE_CONTAINER_NAME);
    }

    public PetiteContainer getPetiteContainer() {
        return this.madpc;
    }

    public void registerComponent(Class component) {
        String name = this.resolveBaseComponentName(component);
        this.registerComponent(name, component);
    }

    public <T> void registerComponent(Class<T> component, Consumer<T> consumer) {
        String name = this.resolveBaseComponentName(component);
        this.registerComponent(name, component, consumer);
    }

    public void registerComponent(String name, Class component) {
        log.debug(() -> "Madvoc WebApp component: [" + name + "] --> " + component.getName());
        this.madpc.removeBean(name);
        this.madpc.registerPetiteBean(component, name, null, null, false, null);
    }

    public <T> void registerComponent(String name, Class<T> component, Consumer<T> consumer) {
        log.debug(() -> "Madvoc WebApp component: [" + name + "] --> " + component.getName());
        this.madpc.removeBean(name);
        this.madpc.registerPetiteBean(component, name, null, null, false, consumer);
    }

    public void registerComponentInstance(Object componentInstance) {
        Class<?> component = componentInstance.getClass();
        String name = this.resolveBaseComponentName(component);
        this.registerComponentInstance(name, componentInstance);
    }

    public void registerComponentInstance(String name, Object componentInstance) {
        log.debug(() -> "Madvoc WebApp component: [" + name + "] --> " + componentInstance.getClass().getName());
        this.madpc.removeBean(name);
        this.madpc.addBean(name, componentInstance);
    }

    public void fireEvent(Class listenerType) {
        MutableInteger newCount;
        HashSet existing = new HashSet();
        do {
            newCount = MutableInteger.of((int)0);
            this.madpc.forEachBeanType(listenerType, name -> {
                if (existing.add(name)) {
                    ++newCount.value;
                    Object listener = this.lookupComponent((String)name);
                    if (listener != null) {
                        MadvocComponentLifecycle.invoke(listener, listenerType);
                    }
                }
            });
        } while (newCount.value != 0);
    }

    public <T> T lookupComponent(Class<T> component) {
        String name = this.resolveBaseComponentName(component);
        return (T)this.madpc.getBean(name);
    }

    public <T> T requestComponent(Class<T> component) {
        T existingComponent = this.lookupComponent(component);
        if (existingComponent == null) {
            throw new MadvocException("Madvoc component not found: " + component.getName());
        }
        return existingComponent;
    }

    public <T> T requestComponent(String componentName) {
        Object existingComponent = this.lookupComponent(componentName);
        if (existingComponent == null) {
            throw new MadvocException("Madvoc component not found: " + componentName);
        }
        return (T)existingComponent;
    }

    public Object lookupComponent(String componentName) {
        return this.madpc.getBean(componentName);
    }

    private String resolveBaseComponentName(Class component) {
        Class superClass;
        Class lastComponent = component;
        while (!(superClass = component.getSuperclass()).equals(Object.class)) {
            component = superClass;
            if (Modifier.isAbstract(component.getModifiers())) continue;
            lastComponent = component;
        }
        return this.madpc.resolveBeanName(lastComponent);
    }

    public void defineParams(Props props) {
        log.debug("Defining Madvoc parameters");
        this.madpc.defineParameters(props);
    }
}

