/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.bean.JoddBean;
import jodd.introspector.MethodDescriptor;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.config.ActionDefinition;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.RouteChunk;
import jodd.madvoc.config.Routes;
import jodd.petite.meta.PetiteInject;
import jodd.util.StringUtil;

public class ActionsManager {
    private static final Logger log = LoggerFactory.getLogger(ActionsManager.class);
    @PetiteInject
    protected ActionMethodParser actionMethodParser;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    protected int actionsCount;
    protected boolean asyncMode = false;
    protected final Routes routes = new Routes(() -> this.madvocConfig);
    protected final HashMap<String, ActionRuntime> runtimes;
    protected Map<String, String> pathAliases = new HashMap<String, String>();

    public ActionsManager() {
        this.runtimes = new HashMap();
    }

    public List<ActionRuntime> getAllActionRuntimes() {
        ArrayList<ActionRuntime> all = new ArrayList<ActionRuntime>(this.actionsCount);
        all.addAll(this.runtimes.values());
        return all;
    }

    public int getActionsCount() {
        return this.actionsCount;
    }

    public boolean isAsyncModeOn() {
        return this.asyncMode;
    }

    public Method resolveActionMethod(Class<?> actionClass, String methodName) {
        MethodDescriptor methodDescriptor = JoddBean.defaults().getClassIntrospector().lookup(actionClass).getMethodDescriptor(methodName, false);
        if (methodDescriptor == null) {
            throw new MadvocException("Public method not found: " + actionClass.getSimpleName() + "#" + methodName);
        }
        return methodDescriptor.getMethod();
    }

    public ActionRuntime registerAction(Class actionClass, String actionMethodName, ActionDefinition actionDefinition) {
        Method actionMethod = this.resolveActionMethod(actionClass, actionMethodName);
        return this.registerAction(actionClass, actionMethod, actionDefinition);
    }

    public ActionRuntime registerAction(Class actionClass, Method actionMethod, ActionDefinition actionDefinition) {
        ActionRuntime actionRuntime = this.actionMethodParser.parse(actionClass, actionMethod, actionDefinition);
        if (actionRuntime == null) {
            return null;
        }
        return this.registerActionRuntime(actionRuntime);
    }

    public ActionRuntime registerActionRuntime(ActionRuntime actionRuntime) {
        String actionPath = actionRuntime.getActionPath();
        String method = actionRuntime.getActionMethod();
        log.debug(() -> "Madvoc action: " + StringUtil.ifNotNull((String)method, m -> m + " ") + actionRuntime.getActionPath() + " => " + actionRuntime.createActionString());
        RouteChunk routeChunk = this.routes.registerPath(method, actionPath);
        if (routeChunk.value() != null) {
            if (this.madvocConfig.isDetectDuplicatePathsEnabled()) {
                throw new MadvocException("Duplicate action path for " + actionRuntime);
            }
        } else {
            ++this.actionsCount;
        }
        routeChunk.bind(actionRuntime);
        this.runtimes.put(actionRuntime.createActionString(), actionRuntime);
        if (actionRuntime.isAsync()) {
            this.asyncMode = true;
        }
        return actionRuntime;
    }

    public ActionRuntime lookup(String method, String[] actionPath) {
        return this.routes.lookup(method, actionPath);
    }

    public ActionRuntime lookup(String actionString) {
        return this.runtimes.get(actionString);
    }

    public void registerPathAlias(String alias, String path) {
        this.pathAliases.put(alias, path);
    }

    public String lookupPathAlias(String alias) {
        return this.pathAliases.get(alias);
    }
}

