/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.petite;

import java.util.Objects;
import java.util.function.Supplier;
import jodd.madvoc.WebApp;
import jodd.madvoc.petite.PetiteFilterManager;
import jodd.madvoc.petite.PetiteInterceptorManager;
import jodd.madvoc.petite.PetiteMadvocController;
import jodd.madvoc.petite.PetiteResultsManager;
import jodd.petite.AutomagicPetiteConfigurator;
import jodd.petite.PetiteContainer;

public class PetiteWebApp
extends WebApp {
    public static final String PETITE_CONTAINER_NAME = "petiteContainer";
    private Supplier<PetiteContainer> petiteContainerSupplier = () -> {
        PetiteContainer pc = new PetiteContainer();
        new AutomagicPetiteConfigurator().configure(pc);
        return pc;
    };

    public PetiteWebApp withPetiteContainer(Supplier<PetiteContainer> petiteContainerSupplier) {
        Objects.requireNonNull(petiteContainerSupplier);
        this.petiteContainerSupplier = petiteContainerSupplier;
        return this;
    }

    @Override
    protected void registerMadvocComponents() {
        super.registerMadvocComponents();
        PetiteContainer petiteContainer = this.petiteContainerSupplier.get();
        this.madvocContainer.registerComponentInstance(PETITE_CONTAINER_NAME, petiteContainer);
        this.madvocContainer.registerComponent(PetiteMadvocController.class);
        this.madvocContainer.registerComponent(PetiteFilterManager.class);
        this.madvocContainer.registerComponent(PetiteInterceptorManager.class);
        this.madvocContainer.registerComponent(PetiteResultsManager.class);
    }
}

