/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocRouter;
import jodd.madvoc.component.ActionMethodParamNameResolver;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.component.ActionPathRewriter;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.AsyncActionExecutor;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InjectorsManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocComponentLifecycle;
import jodd.madvoc.component.MadvocContainer;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.component.ResultMapper;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.component.ServletContextProvider;
import jodd.props.Props;
import jodd.util.ClassConsumer;
import jodd.util.Consumers;

public class WebApp {
    private static Logger log;
    private static final String WEBAPP_ATTR;
    protected ServletContext servletContext;
    private List<Props> propsList = new ArrayList<Props>();
    private List<ClassConsumer> madvocComponents = new ArrayList<ClassConsumer>();
    private List<Object> madvocComponentInstances = new ArrayList<Object>();
    private Consumers<MadvocRouter> madvocRouterConsumers = Consumers.empty();
    private Consumers<MadvocConfig> madvocConfigConsumers = Consumers.empty();
    protected final MadvocContainer madvocContainer;
    protected final Consumers<MadvocContainer> componentConfigs = Consumers.empty();

    public static WebApp createWebApp() {
        return new WebApp();
    }

    public static WebApp get(ServletContext servletContext) {
        return (WebApp)servletContext.getAttribute(WEBAPP_ATTR);
    }

    public WebApp withParams(Props props) {
        this.propsList.add(props);
        return this;
    }

    public WebApp bindServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.servletContext.setAttribute(WEBAPP_ATTR, (Object)this);
        return this;
    }

    public WebApp registerComponent(Class<?> madvocComponent) {
        Objects.requireNonNull(madvocComponent);
        this.madvocComponents.add(ClassConsumer.of(madvocComponent));
        return this;
    }

    public <T> WebApp registerComponent(Class<T> madvocComponent, Consumer<T> componentConsumer) {
        Objects.requireNonNull(madvocComponent);
        this.madvocComponents.add(ClassConsumer.of(madvocComponent, componentConsumer));
        return this;
    }

    public WebApp registerComponent(Object madvocComponent) {
        Objects.requireNonNull(madvocComponent);
        this.madvocComponentInstances.add(madvocComponent);
        return this;
    }

    public WebApp configure(Consumer<MadvocConfig> madvocConfigConsumer) {
        this.madvocConfigConsumers.add(madvocConfigConsumer);
        return this;
    }

    public WebApp() {
        this.madvocContainer = new MadvocContainer();
        this.madvocContainer.registerComponentInstance(this.madvocContainer);
    }

    public MadvocContainer madvocContainer() {
        return this.madvocContainer;
    }

    public <T> WebApp withRegisteredComponent(Class<T> madvocComponent, Consumer<T> componentConsumer) {
        this.componentConfigs.add(madvocContainer -> {
            Object component = madvocContainer.lookupComponent(madvocComponent);
            if (component != null) {
                componentConsumer.accept(component);
            }
        });
        return this;
    }

    public WebApp router(Consumer<MadvocRouter> madvocAppConsumer) {
        this.madvocRouterConsumers.add(madvocAppConsumer);
        return this;
    }

    public WebApp start(Consumer<MadvocRouter> madvocRouterConsumer) {
        this.madvocRouterConsumers.add(madvocRouterConsumer);
        return this.start();
    }

    public WebApp start() {
        log = LoggerFactory.getLogger(WebApp.class);
        log.debug("Initializing Madvoc WebApp");
        for (Props props : this.propsList) {
            this.madvocContainer.defineParams(props);
        }
        this.propsList = null;
        this.madvocContainer.registerComponent(MadvocConfig.class);
        MadvocConfig madvocConfig = this.madvocContainer.requestComponent(MadvocConfig.class);
        this.madvocConfigConsumers.accept((Object)madvocConfig);
        this.configureMadvoc(madvocConfig);
        this.registerMadvocComponents();
        this.madvocComponents.forEach(madvocComponent -> this.madvocContainer.registerComponent(madvocComponent.type(), madvocComponent.consumer()));
        this.madvocComponents = null;
        this.madvocComponentInstances.forEach(this.madvocContainer::registerComponentInstance);
        this.madvocComponentInstances = null;
        this.madvocContainer.fireEvent(MadvocComponentLifecycle.Init.class);
        this.componentConfigs.accept((Object)this.madvocContainer());
        this.initialized();
        this.madvocContainer.fireEvent(MadvocComponentLifecycle.Start.class);
        if (!this.madvocRouterConsumers.isEmpty()) {
            MadvocRouter madvocRouter = MadvocRouter.create();
            this.madvocContainer.registerComponentInstance(madvocRouter);
            this.madvocRouterConsumers.accept((Object)madvocRouter);
        }
        this.madvocRouterConsumers = null;
        this.started();
        this.madvocContainer.fireEvent(MadvocComponentLifecycle.Ready.class);
        this.ready();
        return this;
    }

    protected void configureMadvoc(MadvocConfig madvocConfig) {
    }

    protected void registerMadvocComponents() {
        if (this.madvocContainer == null) {
            throw new MadvocException("Madvoc WebApp not initialized.");
        }
        log.debug("Registering Madvoc WebApp components");
        this.madvocContainer.registerComponentInstance(new ServletContextProvider(this.servletContext));
        this.madvocContainer.registerComponent(ActionMethodParamNameResolver.class);
        this.madvocContainer.registerComponent(ActionMethodParser.class);
        this.madvocContainer.registerComponent(ActionPathRewriter.class);
        this.madvocContainer.registerComponent(ActionsManager.class);
        this.madvocContainer.registerComponent(ContextInjectorComponent.class);
        this.madvocContainer.registerComponent(InjectorsManager.class);
        this.madvocContainer.registerComponent(InterceptorsManager.class);
        this.madvocContainer.registerComponent(FiltersManager.class);
        this.madvocContainer.registerComponent(MadvocController.class);
        this.madvocContainer.registerComponent(ResultsManager.class);
        this.madvocContainer.registerComponent(ResultMapper.class);
        this.madvocContainer.registerComponent(ScopeDataResolver.class);
        this.madvocContainer.registerComponent(AsyncActionExecutor.class);
    }

    protected void initialized() {
    }

    protected void started() {
    }

    protected void ready() {
    }

    public void shutdown() {
        log.info("Madvoc shutting down...");
        this.madvocContainer.fireEvent(MadvocComponentLifecycle.Stop.class);
    }

    static {
        WEBAPP_ATTR = WebApp.class.getName();
    }
}

