/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeType;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.RouteChunk;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Targets;
import jodd.madvoc.macro.PathMacros;
import jodd.util.StringUtil;

public class ActionPathMacroInjector
implements Injector {
    private static final ScopeType SCOPE_TYPE = ScopeType.REQUEST;

    @Override
    public void inject(ActionRequest actionRequest) {
        ActionRuntime actionRuntime = actionRequest.getActionRuntime();
        RouteChunk routeChunk = actionRuntime.getRouteChunk();
        if (!routeChunk.hasMacrosOnPath()) {
            return;
        }
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        String[] actionPath = actionRequest.getActionPathChunks();
        int ndx = actionPath.length - 1;
        RouteChunk chunk = routeChunk;
        while (chunk.parent() != null) {
            PathMacros pathMacros = chunk.pathMacros();
            if (pathMacros != null) {
                this.injectMacros(actionPath[ndx], pathMacros, targets);
            }
            --ndx;
            chunk = chunk.parent();
        }
    }

    private void injectMacros(String actionPath, PathMacros pathMacros, Targets targets) {
        String[] names = pathMacros.names();
        String[] values = pathMacros.extract(actionPath);
        for (int ndx = 0; ndx < values.length; ++ndx) {
            String value = values[ndx];
            if (StringUtil.isEmpty((CharSequence)value)) continue;
            String macroName = names[ndx];
            targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
                String name = in.matchedPropertyName(macroName);
                if (name != null) {
                    target.writeValue(name, value, true);
                }
            });
        }
    }
}

