/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import jodd.io.FileNameUtil;
import jodd.madvoc.MadvocException;
import jodd.madvoc.meta.RenderWith;
import jodd.madvoc.result.RawActionResult;
import jodd.util.net.MimeTypes;

@RenderWith(value=RawActionResult.class)
public class RawData {
    protected final InputStream inputStream;
    protected final int length;
    protected String downloadFileName;
    protected String mimeType = "application/octet-stream";

    public static RawData of(byte[] bytes) {
        return new RawData(new ByteArrayInputStream(bytes), bytes.length);
    }

    public static RawData of(File file) {
        return new RawData(RawData.createFileInputStream(file), (int)file.length()).downloadableAs(file.getName());
    }

    public RawData(InputStream inputStream, int length) {
        this.inputStream = inputStream;
        this.length = length;
    }

    public RawData as(String mimeOrExtension) {
        this.mimeType = mimeOrExtension.contains("/") ? mimeOrExtension : MimeTypes.getMimeType((String)mimeOrExtension);
        return this;
    }

    public RawData asHtml() {
        this.mimeType = "text/html";
        return this;
    }

    public RawData asText() {
        this.mimeType = "text/plain";
        return this;
    }

    public RawData downloadableAs(String downloadFileName) {
        this.downloadFileName = downloadFileName;
        this.mimeType = MimeTypes.getMimeType((String)FileNameUtil.getExtension((String)downloadFileName));
        return this;
    }

    public InputStream contentInputStream() {
        return this.inputStream;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public String downloadFileName() {
        return this.downloadFileName;
    }

    public int contentLength() {
        return this.length;
    }

    private static FileInputStream createFileInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fis) {
            throw new MadvocException(fis);
        }
    }
}

