/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.io.Closeable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jodd.io.StreamUtil;
import jodd.json.JsonSerializer;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.ScopeType;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.Scope;
import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.JsonResult;

public class JsonActionResult
implements ActionResult {
    @In
    @Scope(value=ScopeType.CONTEXT)
    protected MadvocConfig madvocConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(ActionRequest actionRequest, Object object) throws Exception {
        String statusMessage;
        int status;
        String json;
        HttpServletResponse response = actionRequest.getHttpServletResponse();
        String encoding = response.getCharacterEncoding();
        if (encoding == null) {
            encoding = this.madvocConfig.getEncoding();
        }
        response.setContentType("application/json");
        response.setCharacterEncoding(encoding);
        if (object instanceof JsonResult) {
            JsonResult jsonResult = (JsonResult)object;
            json = jsonResult.value();
            status = jsonResult.status();
            statusMessage = jsonResult.message();
        } else {
            json = JsonSerializer.create().deep(true).serialize(object);
            status = 200;
            statusMessage = "OK";
        }
        byte[] data = json.getBytes(encoding);
        response.setContentLength(data.length);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(data);
            if (status < 400) {
                response.setStatus(status);
            } else {
                response.sendError(status, statusMessage);
            }
        }
        finally {
            StreamUtil.close((Closeable)out);
        }
    }
}

