/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeType;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Outjector;
import jodd.madvoc.injector.Targets;
import jodd.servlet.ServletUtil;
import jodd.util.StringUtil;

public class CookieScopeInjector
implements Injector,
Outjector {
    private static final ScopeType SCOPE_TYPE = ScopeType.COOKIE;

    @Override
    public void inject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
            Cookie[] value = null;
            if (in.type == Cookie.class) {
                String cookieName = StringUtil.uncapitalize((String)in.name);
                value = ServletUtil.getCookie((HttpServletRequest)servletRequest, (String)cookieName);
            } else if (in.type.isArray() && in.type.getComponentType().equals(Cookie.class)) {
                value = StringUtil.isEmpty((CharSequence)in.name) ? servletRequest.getCookies() : ServletUtil.getAllCookies((HttpServletRequest)servletRequest, (String)in.name);
            }
            if (value != null) {
                target.writeValue(in.propertyName(), value, true);
            }
        });
    }

    @Override
    public void outject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        targets.forEachTargetAndOutScopes(SCOPE_TYPE, (target, out) -> {
            Cookie cookie = (Cookie)target.readTargetProperty((ScopeData.Out)out);
            if (cookie != null) {
                servletResponse.addCookie(cookie);
            }
        });
    }
}

