/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeType;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.injector.ContextInjector;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Outjector;
import jodd.madvoc.injector.Targets;

public class ApplicationScopeInjector
implements Injector,
Outjector,
ContextInjector<ServletContext> {
    private static final ScopeType SCOPE_TYPE = ScopeType.APPLICATION;

    @Override
    public void inject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        ServletContext servletContext = actionRequest.getHttpServletRequest().getSession().getServletContext();
        Enumeration attributeNames = servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
                String name = in.matchedPropertyName(attrName);
                if (name != null) {
                    Object attrValue = servletContext.getAttribute(attrName);
                    target.writeValue(name, attrValue, true);
                }
            });
        }
    }

    @Override
    public void injectContext(Targets targets, ServletContext servletContext) {
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        Enumeration attributeNames = servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
                String name = in.matchedPropertyName(attrName);
                if (name != null) {
                    Object attrValue = servletContext.getAttribute(attrName);
                    target.writeValue(name, attrValue, true);
                }
            });
        }
    }

    @Override
    public void outject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        ServletContext context = actionRequest.getHttpServletRequest().getSession().getServletContext();
        targets.forEachTargetAndOutScopes(SCOPE_TYPE, (target, out) -> {
            Object value = target.readTargetProperty((ScopeData.Out)out);
            context.setAttribute(out.name, value);
        });
    }
}

