/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.ChainResult;
import jodd.madvoc.result.MoveResult;
import jodd.madvoc.result.NoneResult;
import jodd.madvoc.result.ServletDispatcherResult;
import jodd.madvoc.result.ServletRedirectResult;
import jodd.madvoc.result.ServletUrlRedirectResult;
import jodd.madvoc.result.TextResult;
import jodd.methref.Methref;

public class Result {
    protected Class<? extends ActionResult> actionResult;
    protected String resultValue;
    protected Methref methref;
    protected Class target;

    public Result with(Class<? extends ActionResult> actionResult) {
        this.actionResult = actionResult;
        return this;
    }

    public Result value(String resultValue) {
        this.resultValue = resultValue;
        return this;
    }

    public String value() {
        if (this.methref != null) {
            String methodName = this.methref.ref();
            return this.target.getName() + "#" + methodName;
        }
        return this.resultValue;
    }

    protected <T> T wrapAction(Class<T> target) {
        this.target = target;
        this.methref = Methref.on(target);
        this.resultValue = null;
        return (T)this.methref.to();
    }

    public void forward() {
        this.actionResult = ServletDispatcherResult.class;
        this.resultValue = null;
        this.methref = null;
    }

    public void forwardTo(String path) {
        this.actionResult = ServletDispatcherResult.class;
        this.resultValue = path;
        this.methref = null;
    }

    public <T> T forwardTo(Class<T> target) {
        this.actionResult = ServletDispatcherResult.class;
        return this.wrapAction(target);
    }

    public <T> T forwardTo(T target) {
        this.actionResult = ServletDispatcherResult.class;
        return (T)this.wrapAction(target.getClass());
    }

    public void forwardTo(Result result, String append) {
        this.resultValue = "/<" + result.value() + ">.." + append;
        this.methref = null;
    }

    public void redirectTo(String path) {
        this.actionResult = ServletRedirectResult.class;
        this.resultValue = path;
        this.methref = null;
    }

    public <T> T redirectTo(Class<T> target) {
        this.actionResult = ServletRedirectResult.class;
        return this.wrapAction(target);
    }

    public <T> T redirectTo(T target) {
        this.actionResult = ServletRedirectResult.class;
        return (T)this.wrapAction(target.getClass());
    }

    public void redirectTo(Result result, String append) {
        this.resultValue = "/<" + result.value() + ">" + append;
        this.methref = null;
    }

    public void urlTo(String path) {
        this.actionResult = ServletUrlRedirectResult.class;
        this.resultValue = path;
        this.methref = null;
    }

    public void chainTo(String path) {
        this.actionResult = ChainResult.class;
        this.resultValue = path;
        this.methref = null;
    }

    public <T> T chainTo(Class<T> target) {
        this.actionResult = ChainResult.class;
        return this.wrapAction(target);
    }

    public <T> T chainTo(T target) {
        this.actionResult = ChainResult.class;
        return (T)this.wrapAction(target.getClass());
    }

    public void moveTo(String path) {
        this.actionResult = MoveResult.class;
        this.resultValue = path;
        this.methref = null;
    }

    public <T> T moveTo(Class<T> target) {
        this.actionResult = MoveResult.class;
        return this.wrapAction(target);
    }

    public <T> T moveTo(T target) {
        this.actionResult = MoveResult.class;
        return (T)this.wrapAction(target.getClass());
    }

    public void nothing() {
        this.actionResult = NoneResult.class;
        this.resultValue = null;
    }

    public void text(String text) {
        this.actionResult = TextResult.class;
        this.resultValue = text;
    }

    public void url(String url) {
        this.actionResult = ServletUrlRedirectResult.class;
        this.resultValue = url;
    }

    public Class<? extends ActionResult> getActionResult() {
        return this.actionResult;
    }

    public Object getResultValue() {
        return this.resultValue;
    }
}

