/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.interceptor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.PropertyDescriptor;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.interceptor.BaseActionInterceptor;

public abstract class AnnotatedPropertyInterceptor
extends BaseActionInterceptor {
    protected final Class<Annotation> annotations;
    protected Map<Class<?>, PropertyDescriptor[]> annotatedProperties = new HashMap();
    protected static final PropertyDescriptor[] EMPTY = new PropertyDescriptor[0];

    protected AnnotatedPropertyInterceptor(Class<Annotation> annotations) {
        this.annotations = annotations;
    }

    @Override
    public Object intercept(ActionRequest actionRequest) throws Exception {
        PropertyDescriptor[] allProperties;
        Object action = actionRequest.getAction();
        Class<?> actionType = action.getClass();
        for (PropertyDescriptor propertyDescriptor : allProperties = this.lookupAnnotatedProperties(actionType)) {
            this.onAnnotatedProperty(actionRequest, propertyDescriptor);
        }
        return actionRequest.invoke();
    }

    protected abstract void onAnnotatedProperty(ActionRequest var1, PropertyDescriptor var2);

    protected PropertyDescriptor[] lookupAnnotatedProperties(Class type) {
        PropertyDescriptor[] properties = this.annotatedProperties.get(type);
        if (properties != null) {
            return properties;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        PropertyDescriptor[] allProperties = cd.getAllPropertyDescriptors();
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : allProperties) {
            Annotation ann = null;
            if (propertyDescriptor.getFieldDescriptor() != null) {
                ann = propertyDescriptor.getFieldDescriptor().getField().getAnnotation(this.annotations);
            }
            if (ann == null && propertyDescriptor.getWriteMethodDescriptor() != null) {
                ann = propertyDescriptor.getWriteMethodDescriptor().getMethod().getAnnotation(this.annotations);
            }
            if (ann == null && propertyDescriptor.getReadMethodDescriptor() != null) {
                ann = propertyDescriptor.getReadMethodDescriptor().getMethod().getAnnotation(this.annotations);
            }
            if (ann == null) continue;
            list.add(propertyDescriptor);
        }
        properties = list.isEmpty() ? EMPTY : list.toArray(new PropertyDescriptor[list.size()]);
        this.annotatedProperties.put(type, properties);
        return properties;
    }
}

