/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.io.StreamUtil;
import jodd.madvoc.ActionWrapper;
import jodd.madvoc.MadvocException;
import jodd.madvoc.config.ManualMadvocConfigurator;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.ActionResult;
import jodd.typeconverter.Convert;
import jodd.util.ArraysUtil;
import jodd.util.ClassLoaderUtil;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;

public class RouteMadvocConfigurator
extends ManualMadvocConfigurator {
    protected HashMap<String, String> variables;
    protected Class<? extends ActionWrapper>[] currentWrappers;
    protected String[] IGNORED_FIXES = new String[]{"\"", "\"", "'", "'", "`", "`", "{", "}", "(", ")", "[", "]", "", ",", "", ";", "", ":"};

    @Override
    public void configure() {
        String routes;
        String fileName = this.madvocConfig.getRoutesFileName();
        URL url = ClassLoaderUtil.getResourceUrl((String)("/" + fileName));
        if (url == null) {
            throw new MadvocException("Routes file not found: " + fileName);
        }
        InputStream in = null;
        try {
            in = url.openStream();
            char[] chars = StreamUtil.readChars((InputStream)in, (String)"UTF-8");
            routes = new String(chars);
        }
        catch (IOException ioex) {
            throw new MadvocException(ioex);
        }
        finally {
            StreamUtil.close((Closeable)in);
        }
        try {
            this.parse(routes);
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
    }

    protected void parse(String routes) throws Exception {
        this.initDefaultWrappers();
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        int start = 0;
        while (start < routes.length()) {
            int ndx = routes.indexOf(10, start);
            if (ndx == -1) {
                ndx = routes.length();
            }
            String newLine = routes.substring(start, ndx).trim();
            start = ndx + 1;
            boolean join = false;
            if (newLine.endsWith("\\")) {
                newLine = StringUtil.substring((String)newLine, (int)0, (int)-1);
                join = true;
            }
            line = line == null ? newLine : line + newLine;
            if (join) continue;
            if (!StringUtil.isEmpty((CharSequence)line)) {
                lines.add(line);
            }
            line = null;
        }
        for (String aline : lines) {
            this.parseLine(aline);
        }
    }

    protected void initDefaultWrappers() {
        Class<? extends ActionFilter>[] defaultWebAppFilterClasses;
        String defaultWrappers = "";
        this.variables = new HashMap();
        Class<? extends ActionInterceptor>[] defaultWebAppInterceptorClasses = this.madvocConfig.getDefaultInterceptors();
        if (defaultWebAppInterceptorClasses != null) {
            for (Class<? extends ActionInterceptor> interceptorClass : defaultWebAppInterceptorClasses) {
                defaultWrappers = defaultWrappers + interceptorClass.getName();
                defaultWrappers = defaultWrappers + ".class ";
            }
        }
        if ((defaultWebAppFilterClasses = this.madvocConfig.getDefaultFilters()) != null) {
            for (Class<? extends ActionFilter> filterClass : defaultWebAppFilterClasses) {
                defaultWrappers = defaultWrappers + filterClass.getName();
                defaultWrappers = defaultWrappers + ".class ";
            }
        }
        defaultWrappers = defaultWrappers.trim();
        this.variables.put("default.wrappers", defaultWrappers);
        this.processDefaults(defaultWrappers);
    }

    protected void parseLine(String line) throws Exception {
        int ndx;
        if (line.startsWith("@") && (ndx = line.indexOf(61)) != -1) {
            String groupName = line.substring(1, ndx).trim();
            line = line.substring(ndx + 1).trim();
            this.variables.put(groupName, line);
            return;
        }
        if (line.startsWith("#")) {
            return;
        }
        if ((line = this.replaceVariables(line)).startsWith("[") && line.endsWith("]")) {
            line = StringUtil.substring((String)line, (int)1, (int)-1).trim();
            this.processDefaults(line);
            return;
        }
        String[] chunks = StringUtil.splitc((String)line, (String)" \t");
        ManualMadvocConfigurator.ActionBuilder action = this.action();
        Object[] wrappers = new Class[]{};
        for (String chunk : chunks) {
            String flag;
            if (StringUtil.isBlank((CharSequence)(chunk = this.trimPrefixAndSuffix(chunk)))) continue;
            if (chunk.startsWith("/")) {
                if (action.isSet()) {
                    action.resultBase(chunk);
                    continue;
                }
                action.path(chunk);
                continue;
            }
            if (chunk.startsWith("#") && (flag = chunk.substring(1)).equals("async")) {
                action.async(true);
                continue;
            }
            if (chunk.contains("#")) {
                String[] names = StringUtil.splitc((String)chunk, (char)'#');
                if (names.length != 2) continue;
                String className = names[0];
                Class actionClass = ClassLoaderUtil.loadClass((String)className);
                action.mapTo(actionClass, names[1]);
                continue;
            }
            if (chunk.endsWith(".class")) {
                Class chunkClass = Convert.toClass((Object)chunk);
                if (ReflectUtil.isTypeOf((Class)chunkClass, ActionResult.class)) {
                    if (action.isSet()) {
                        action.renderWith(chunkClass);
                        continue;
                    }
                    this.result(chunkClass);
                    continue;
                }
                if (ReflectUtil.isTypeOf((Class)chunkClass, ActionWrapper.class)) {
                    wrappers = (Class[])ArraysUtil.append((Object[])wrappers, (Object)chunkClass);
                    continue;
                }
                throw new MadvocException("Unsupported type: " + chunk);
            }
            if (chunk.equals("GET") || chunk.equals("HEAD") || chunk.equals("POST") || chunk.equals("PUT") || chunk.equals("DELETE") || chunk.equals("TRACE") || chunk.equals("OPTIONS") || chunk.equals("CONNECT") || chunk.equals("PATCH")) {
                action.httpMethod(chunk);
                continue;
            }
            action.alias(chunk);
        }
        if (wrappers.length == 0) {
            wrappers = this.currentWrappers;
        }
        for (Object wrapper : wrappers) {
            if (ReflectUtil.isTypeOf((Class)wrapper, ActionInterceptor.class)) {
                action.interceptBy((Class<? extends ActionInterceptor>)wrapper);
                continue;
            }
            if (ReflectUtil.isTypeOf((Class)wrapper, ActionFilter.class)) {
                action.filterBy((Class<? extends ActionFilter>)wrapper);
                continue;
            }
            throw new MadvocException("Invalid wrapper: " + ((Class)wrapper).getName());
        }
        if (action.isSet()) {
            action.bind();
        }
    }

    protected String trimPrefixAndSuffix(String chunk) {
        for (int i = 0; i < this.IGNORED_FIXES.length; i += 2) {
            String left = this.IGNORED_FIXES[i];
            String right = this.IGNORED_FIXES[i + 1];
            if (!chunk.startsWith(left) || !chunk.endsWith(right)) continue;
            chunk = StringUtil.substring((String)chunk, (int)left.length(), (int)(-right.length()));
            break;
        }
        return chunk;
    }

    protected void processDefaults(String line) {
        String[] chunks = StringUtil.splitc((String)line, (String)" \t");
        Object[] wrappers = new Class[]{};
        for (String chunk : chunks) {
            Class type;
            if (StringUtil.isBlank((CharSequence)(chunk = this.trimPrefixAndSuffix(chunk))) || !ReflectUtil.isTypeOf((Class)(type = Convert.toClass((Object)chunk)), ActionWrapper.class)) continue;
            wrappers = (Class[])ArraysUtil.append((Object[])wrappers, (Object)type);
        }
        if (wrappers.length != 0) {
            this.currentWrappers = wrappers;
        }
    }

    protected String replaceVariables(String line) {
        for (Map.Entry<String, String> entry : this.variables.entrySet()) {
            String name = "@" + entry.getKey();
            String value = entry.getValue();
            line = StringUtil.replace((String)line, (String)name, (String)value);
        }
        return line;
    }
}

