/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.lang.reflect.Constructor;
import jodd.bean.BeanUtil;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocException;
import jodd.typeconverter.TypeConverterManager;

public class Target {
    private static final Logger log = LoggerFactory.getLogger(Target.class);
    protected final Class type;
    protected Object value;

    public Target(Object value) {
        this.value = value;
        this.type = null;
    }

    public Target(Object value, Class type) {
        this.value = value;
        this.type = type;
    }

    public Target(Class type) {
        this.type = type;
        this.value = null;
    }

    public Class getType() {
        return this.type;
    }

    public Class resolveType() {
        if (this.type != null) {
            return this.type;
        }
        return this.value.getClass();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object readValue(String propertyName) {
        if (this.type != null) {
            int dotNdx = propertyName.indexOf(46);
            if (dotNdx == -1) {
                return this.value;
            }
            propertyName = propertyName.substring(dotNdx + 1);
        }
        return BeanUtil.getDeclaredProperty((Object)this.value, (String)propertyName);
    }

    public void writeValue(String propertyName, Object propertyValue, boolean throwExceptionOnError) {
        if (this.type != null) {
            int dotNdx = propertyName.indexOf(46);
            if (dotNdx == -1) {
                try {
                    this.value = TypeConverterManager.convertType((Object)propertyValue, (Class)this.type);
                }
                catch (Exception ex) {
                    this.handleException(propertyName, throwExceptionOnError, ex);
                }
                return;
            }
            if (this.value == null) {
                this.createValueInstance();
            }
            propertyName = propertyName.substring(dotNdx + 1);
        }
        if (BeanUtil.hasDeclaredRootProperty((Object)this.value, (String)propertyName)) {
            try {
                BeanUtil.setDeclaredPropertyForced((Object)this.value, (String)propertyName, (Object)propertyValue);
            }
            catch (Exception ex) {
                this.handleException(propertyName, throwExceptionOnError, ex);
            }
        }
    }

    protected void createValueInstance() {
        try {
            Constructor ctor = this.type.getDeclaredConstructor(null);
            ctor.setAccessible(true);
            this.value = ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
    }

    protected void handleException(String propertyName, boolean throwExceptionOnError, Exception ex) {
        if (throwExceptionOnError) {
            if (ex instanceof MadvocException) {
                throw (MadvocException)((Object)ex);
            }
            throw new MadvocException(ex);
        }
        if (log.isWarnEnabled()) {
            log.warn("Injection failed: " + propertyName + ". " + ex.toString());
        }
    }
}

