/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.interceptor;

import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.injector.RequestScopeInjector;
import jodd.madvoc.interceptor.BaseActionInterceptor;
import jodd.madvoc.interceptor.Preparable;
import jodd.madvoc.meta.In;
import jodd.util.StringUtil;

public class PreparableInterceptor
extends BaseActionInterceptor {
    protected static final String[] ATTR_NAME_ID_SUFFIXES = new String[]{".id", "Id"};
    @In(scope=ScopeType.CONTEXT)
    protected MadvocConfig madvocConfig;
    @In(scope=ScopeType.CONTEXT)
    protected ScopeDataResolver scopeDataResolver;
    protected RequestScopeInjector requestInjector;
    protected boolean isInjectIdsFromRequestEnabled = false;

    public void init() {
        this.requestInjector = new RequestScopeInjector(this.madvocConfig, this.scopeDataResolver){

            protected String getMatchedPropertyName(ScopeData.In in, String attrName) {
                if (StringUtil.endsWithOne((String)attrName, (String[])ATTR_NAME_ID_SUFFIXES) == -1) {
                    return null;
                }
                return super.getMatchedPropertyName(in, attrName);
            }
        };
        this.requestInjector.setInjectAttributes(false);
    }

    public boolean isInjectIdsFromRequestEnabled() {
        return this.isInjectIdsFromRequestEnabled;
    }

    public void setInjectIdsFromRequestEnabled(boolean isInjectIdsFromRequestEnabled) {
        this.isInjectIdsFromRequestEnabled = isInjectIdsFromRequestEnabled;
    }

    public Object intercept(ActionRequest actionRequest) throws Exception {
        Object action = actionRequest.getAction();
        if (action instanceof Preparable) {
            if (this.isInjectIdsFromRequestEnabled) {
                this.injectIdsFromRequest(actionRequest);
            }
            ((Preparable)action).prepare();
        }
        return actionRequest.invoke();
    }

    protected void injectIdsFromRequest(ActionRequest actionRequest) {
        this.requestInjector.inject(actionRequest);
    }
}

