/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import jodd.madvoc.result.ActionResult;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseActionResult<T>
implements ActionResult<T> {
    protected final String resultName;
    protected final Class<T> resultValueType;

    protected BaseActionResult(String resultName) {
        this.resultName = resultName;
        this.resultValueType = this.resolveResultValueType();
    }

    protected BaseActionResult() {
        this.resultName = null;
        this.resultValueType = this.resolveResultValueType();
    }

    protected Class<T> resolveResultValueType() {
        Class<?> clazz = this.getClass();
        while (clazz.getSuperclass() != BaseActionResult.class) {
            Class rvt = ReflectUtil.getGenericSupertype(clazz);
            if (rvt != null) {
                return rvt;
            }
            clazz = clazz.getSuperclass();
        }
        return ReflectUtil.getGenericSupertype(clazz);
    }

    @Override
    public String getResultName() {
        return this.resultName;
    }

    @Override
    public Class<T> getResultValueType() {
        return this.resultValueType;
    }

    @Override
    public void init() {
    }

    public String toString() {
        return "Result: " + this.getClass().getSimpleName() + (this.resultName != null ? ":" + this.resultName : "") + (this.resultValueType != null ? ":" + this.resultValueType.getName() : "");
    }
}

