/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.ResultPath;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ResultMapper;
import jodd.madvoc.meta.In;
import jodd.madvoc.result.BaseActionResult;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplateViewResult
extends BaseActionResult<String> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTemplateViewResult.class);
    protected HashMap<String, String> targetCache = new HashMap(256);
    @In(scope=ScopeType.CONTEXT)
    protected ResultMapper resultMapper;

    public AbstractTemplateViewResult(String name) {
        super(name);
    }

    @Override
    public void render(ActionRequest actionRequest, String resultValue) throws Exception {
        String resultBasePath = actionRequest.getActionConfig().getResultBasePath();
        String actionAndResultPath = resultBasePath + (resultValue != null ? ':' + resultValue : "");
        String target = this.targetCache.get(actionAndResultPath);
        if (target == null) {
            if (log.isDebugEnabled()) {
                log.debug("new target: " + actionAndResultPath);
            }
            if ((target = this.resolveTarget(actionRequest, resultValue)) == null) {
                this.targetNotFound(actionRequest, actionAndResultPath);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("target found: " + target);
            }
            this.targetCache.put(actionAndResultPath, target);
        }
        this.renderView(actionRequest, target);
    }

    protected String resolveTarget(ActionRequest actionRequest, String resultValue) {
        String target;
        String actionPath;
        String resultBasePath = actionRequest.getActionConfig().getResultBasePath();
        ResultPath resultPath = this.resultMapper.resolveResultPath(resultBasePath, resultValue);
        String path = actionPath = resultPath.getPath();
        String value = resultPath.getValue();
        if (StringUtil.isEmpty((CharSequence)value)) {
            value = null;
        }
        while (true) {
            if (value != null) {
                int lastSlashNdx;
                target = path == null ? ((lastSlashNdx = actionPath.lastIndexOf(47)) != -1 ? actionPath.substring(0, lastSlashNdx + 1) + value : '/' + value) : path + '.' + value;
                target = this.locateTarget(actionRequest, target);
                if (target != null) break;
            }
            if (path != null && (target = this.locateTarget(actionRequest, path)) != null) break;
            if (path == null) {
                return null;
            }
            int dotNdx = MadvocUtil.lastIndexOfDotAfterSlash(path);
            if (dotNdx == -1) {
                path = null;
                continue;
            }
            path = path.substring(0, dotNdx);
        }
        return target;
    }

    protected abstract String locateTarget(ActionRequest var1, String var2);

    protected abstract void renderView(ActionRequest var1, String var2) throws Exception;

    protected void targetNotFound(ActionRequest actionRequest, String actionAndResultPath) throws IOException {
        HttpServletResponse response = actionRequest.getHttpServletResponse();
        response.sendError(404, "Result not found: " + actionAndResultPath);
    }
}

