/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.injector.Target;
import jodd.madvoc.meta.RenderWith;
import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.Result;
import jodd.petite.meta.PetiteInject;
import jodd.typeconverter.TypeConverterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsManager {
    private static final Logger log = LoggerFactory.getLogger(ResultsManager.class);
    @PetiteInject
    protected ContextInjectorComponent contextInjectorComponent;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    protected final Map<String, ActionResult> stringResults = new HashMap<String, ActionResult>();
    protected final Map<Class, ActionResult> typeResults;
    protected final Map<Class<? extends ActionResult>, ActionResult> allResults = new HashMap<Class<? extends ActionResult>, ActionResult>();

    public ResultsManager() {
        this.typeResults = new HashMap<Class, ActionResult>();
    }

    public Set<ActionResult> getAllActionResults() {
        HashSet<ActionResult> set = new HashSet<ActionResult>(this.allResults.size());
        set.addAll(this.allResults.values());
        return set;
    }

    public ActionResult register(Class<? extends ActionResult> resultClass) {
        return this.register(this.createResult(resultClass));
    }

    protected ActionResult register(ActionResult result) {
        Class resultValueType;
        Class<?> actionResultClass = result.getClass();
        ActionResult existingResult = this.allResults.get(actionResultClass);
        if (existingResult != null) {
            if (log.isDebugEnabled()) {
                log.debug("ActionResult already registered: " + actionResultClass);
            }
            return existingResult;
        }
        String resultName = result.getResultName();
        if (resultName != null) {
            existingResult = this.stringResults.get(resultName);
            if (existingResult != null) {
                if (!this.resultMayReplaceExistingOne(actionResultClass)) {
                    if (log.isDebugEnabled()) {
                        log.debug("ActionResult already registered: " + actionResultClass);
                    }
                    return existingResult;
                }
                this.allResults.remove(existingResult.getClass());
            }
            if (log.isInfoEnabled()) {
                log.debug("ActionResult registered: " + resultName + " -> " + actionResultClass);
            }
            this.stringResults.put(resultName, result);
        }
        if ((resultValueType = result.getResultValueType()) != null && resultValueType != String.class) {
            existingResult = this.typeResults.get(resultValueType);
            if (existingResult != null) {
                if (!this.resultMayReplaceExistingOne(actionResultClass)) {
                    if (log.isDebugEnabled()) {
                        log.debug("ActionResult already registered: " + actionResultClass);
                    }
                    return existingResult;
                }
                this.allResults.remove(existingResult.getClass());
            }
            if (log.isInfoEnabled()) {
                log.debug("ActionResult registered: " + resultValueType + " -> " + actionResultClass);
            }
            this.typeResults.put(resultValueType, result);
        }
        if (log.isInfoEnabled()) {
            log.debug("ActionResult registered: " + actionResultClass);
        }
        this.allResults.put(actionResultClass, result);
        this.initializeResult(result);
        return result;
    }

    protected boolean resultMayReplaceExistingOne(Class<? extends ActionResult> actionResultClass) {
        String packageName = actionResultClass.getPackage().getName();
        return !packageName.startsWith("jodd.");
    }

    private ActionResult lookupAndRegisterIfMissing(Class<? extends ActionResult> actionResultClass) {
        ActionResult actionResult = this.allResults.get(actionResultClass);
        if (actionResult == null) {
            actionResult = this.register(actionResultClass);
        }
        return actionResult;
    }

    public ActionResult lookup(ActionRequest actionRequest, Object resultObject) {
        Class<?> resultType;
        ActionConfig actionConfig;
        Class<? extends ActionResult> actionResultClass;
        Result result;
        ActionResult actionResult = null;
        if (resultObject == null && (result = actionRequest.getResult()) != null) {
            actionResultClass = result.getActionResult();
            resultObject = result.getResultValue();
            if (resultObject == null) {
                resultObject = result.value();
            }
            if (actionResultClass != null) {
                actionResult = this.lookupAndRegisterIfMissing(actionResultClass);
            }
        }
        if (actionResult == null && (actionResultClass = (actionConfig = actionRequest.getActionConfig()).getActionResult()) != null) {
            actionResult = this.lookupAndRegisterIfMissing(actionResultClass);
        }
        if (actionResult == null && resultObject != null && (resultType = resultObject.getClass()) != String.class) {
            RenderWith renderWith = resultObject.getClass().getAnnotation(RenderWith.class);
            if (renderWith != null) {
                actionResult = this.lookupAndRegisterIfMissing(renderWith.value());
            }
            if (actionResult == null) {
                actionResult = this.typeResults.get(resultObject.getClass());
            }
        }
        if (actionResult == null) {
            ActionResult defaultActionResult = this.lookupAndRegisterIfMissing(this.madvocConfig.getDefaultActionResult());
            if (this.stringResults.isEmpty()) {
                actionResult = defaultActionResult;
            } else {
                int columnIndex;
                String resultValue = resultObject != null ? resultObject.toString() : null;
                String resultName = null;
                if (resultValue != null && (columnIndex = resultValue.indexOf(58)) != -1) {
                    resultName = resultValue.substring(0, columnIndex);
                    resultValue = resultValue.substring(columnIndex + 1);
                }
                if ((actionResult = resultName != null ? this.stringResults.get(resultName) : defaultActionResult).getResultName() != null) {
                    try {
                        Class targetClass = actionResult.getResultValueType();
                        resultObject = targetClass == null || targetClass == String.class ? resultValue : TypeConverterManager.convertType((Object)resultValue, targetClass);
                    }
                    catch (Exception ex) {
                        resultObject = resultValue;
                    }
                }
            }
        }
        actionRequest.setActionResult(resultObject);
        return actionResult;
    }

    protected void initializeResult(ActionResult result) {
        this.contextInjectorComponent.injectContext(new Target(result));
        result.init();
    }

    protected ActionResult createResult(Class<? extends ActionResult> actionResultClass) {
        try {
            return actionResultClass.newInstance();
        }
        catch (Exception ex) {
            throw new MadvocException("Invalid Madvoc result: " + actionResultClass, ex);
        }
    }
}

