/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.component.ActionMethodParamNameResolver;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.component.ActionPathMacroManager;
import jodd.madvoc.component.ActionPathRewriter;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InjectorsManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.component.ResultMapper;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.config.MadvocConfigurator;
import jodd.petite.PetiteContainer;
import jodd.props.Props;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApplication {
    private static Logger log;
    public static final String MADVOC_CONTAINER_NAME = "madpc";
    protected PetiteContainer madpc;

    public WebApplication() {
    }

    public WebApplication(boolean init) {
        if (init) {
            this.initWebApplication();
        }
    }

    protected void initWebApplication() {
        log = LoggerFactory.getLogger(WebApplication.class);
        log.debug("Initializing Madvoc web application");
        this.madpc = new PetiteContainer();
        this.madpc.addSelf(MADVOC_CONTAINER_NAME);
    }

    private String resolveBaseComponentName(Class component) {
        Class superClass;
        Class lastComponent = component;
        while (!(superClass = component.getSuperclass()).equals(Object.class)) {
            component = superClass;
            if (Modifier.isAbstract(component.getModifiers())) continue;
            lastComponent = component;
        }
        return this.madpc.resolveBeanName(lastComponent);
    }

    public final void registerComponent(Class component) {
        String name = this.resolveBaseComponentName(component);
        this.registerComponent(name, component);
    }

    public final void registerComponent(String name, Class component) {
        if (log.isDebugEnabled()) {
            log.debug("Registering component '" + name + "' of type " + component.getName());
        }
        this.madpc.removeBean(name);
        this.madpc.registerPetiteBean(component, name, null, null, false);
    }

    public final void registerComponent(Object componentInstance) {
        Class<?> component = componentInstance.getClass();
        String name = this.resolveBaseComponentName(component);
        this.registerComponent(name, componentInstance);
    }

    public final void registerComponent(String name, Object componentInstance) {
        if (log.isDebugEnabled()) {
            log.debug("Registering component '" + name + "' instance of " + componentInstance.getClass().getName());
        }
        this.madpc.removeBean(name);
        this.madpc.addBean(name, componentInstance);
    }

    public <T> T getComponent(Class<T> component) {
        String name = this.resolveBaseComponentName(component);
        return (T)this.madpc.getBean(name);
    }

    public Object getComponent(String componentName) {
        return this.madpc.getBean(componentName);
    }

    public void registerMadvocComponents() {
        log.debug("Registering Madvoc components");
        this.registerComponent(ActionMethodParser.class);
        this.registerComponent(ActionMethodParamNameResolver.class);
        this.registerComponent(ActionPathRewriter.class);
        this.registerComponent(ActionPathMacroManager.class);
        this.registerComponent(ActionsManager.class);
        this.registerComponent(ContextInjectorComponent.class);
        this.registerComponent(InjectorsManager.class);
        this.registerComponent(InterceptorsManager.class);
        this.registerComponent(FiltersManager.class);
        this.registerComponent(MadvocConfig.class);
        this.registerComponent(MadvocController.class);
        this.registerComponent(ResultsManager.class);
        this.registerComponent(ResultMapper.class);
        this.registerComponent(ScopeDataResolver.class);
    }

    protected void defineParams(Properties properties) {
        log.debug("Defining Madvoc parameters");
        this.madpc.defineParameters((Map)properties);
    }

    protected void defineParams(Props props) {
        log.debug("Defining Madvoc parameters");
        this.madpc.defineParameters(props);
    }

    protected void init(MadvocConfig madvocConfig, ServletContext servletContext) {
        log.debug("Initializing Madvoc");
    }

    protected void initFilters(FiltersManager filtersManager) {
        log.debug("Initializing Madvoc filters");
    }

    protected void initInterceptors(InterceptorsManager interceptorsManager) {
        log.debug("Initializing Madvoc interceptors");
    }

    protected void initActions(ActionsManager actionManager) {
        log.debug("Initializing Madvoc actions");
    }

    protected void initResults(ResultsManager actionManager) {
        log.debug("Initializing Madvoc results");
    }

    protected void ready() {
        log.info("Madvoc is ready");
    }

    protected void destroy(MadvocConfig madvocConfig) {
        log.debug("Destroying Madvoc");
    }

    public void configure(MadvocConfigurator configurator) {
        log.debug("Configuring Madvoc");
        this.registerComponent(configurator);
        configurator.configure();
    }
}

