/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.injector.BaseScopeInjector;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Outjector;
import jodd.madvoc.injector.Target;

public class SessionScopeInjector
extends BaseScopeInjector
implements Injector,
Outjector {
    public SessionScopeInjector(MadvocConfig madvocConfig, ScopeDataResolver scopeDataResolver) {
        super(ScopeType.SESSION, madvocConfig, scopeDataResolver);
    }

    public void inject(ActionRequest actionRequest) {
        ScopeData[] injectData = this.lookupScopeData(actionRequest);
        if (injectData == null) {
            return;
        }
        Target[] targets = actionRequest.getTargets();
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpSession session = servletRequest.getSession();
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            for (int i = 0; i < targets.length; ++i) {
                ScopeData.In[] scopes;
                Target target = targets[i];
                if (injectData[i] == null || (scopes = injectData[i].in) == null) continue;
                for (ScopeData.In in : scopes) {
                    String name = this.getMatchedPropertyName(in, attrName);
                    if (name == null) continue;
                    Object attrValue = session.getAttribute(attrName);
                    this.setTargetProperty(target, name, attrValue);
                }
            }
        }
    }

    public void outject(ActionRequest actionRequest) {
        ScopeData[] outjectData = this.lookupScopeData(actionRequest);
        if (outjectData == null) {
            return;
        }
        Target[] targets = actionRequest.getTargets();
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpSession session = servletRequest.getSession();
        for (int i = 0; i < targets.length; ++i) {
            ScopeData.Out[] scopes;
            Target target = targets[i];
            if (outjectData[i] == null || (scopes = outjectData[i].out) == null) continue;
            for (ScopeData.Out out : scopes) {
                Object value = this.getTargetProperty(target, out);
                session.setAttribute(out.name, value);
            }
        }
    }
}

