/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.injector.Target;

public abstract class BaseScopeInjector {
    protected final ScopeDataResolver scopeDataResolver;
    protected final ScopeType scopeType;
    protected final MadvocConfig madvocConfig;

    protected BaseScopeInjector(ScopeType scopeType, MadvocConfig madvocConfig, ScopeDataResolver scopeDataResolver) {
        this.scopeType = scopeType;
        this.madvocConfig = madvocConfig;
        this.scopeDataResolver = scopeDataResolver;
    }

    protected void setTargetProperty(Target target, String name, Object value) {
        target.writeValue(name, value, this.madvocConfig.isInjectionErrorThrowsException());
    }

    protected Object getTargetProperty(Target target, ScopeData.Out out) {
        if (out.target == null) {
            return target.readValue(out.name);
        }
        return target.readValue(out.target);
    }

    protected String getMatchedPropertyName(ScopeData.In in, String attrName) {
        char c;
        if (!attrName.startsWith(in.name)) {
            return null;
        }
        int requiredLen = in.name.length();
        if (attrName.length() >= requiredLen + 1 && (c = attrName.charAt(requiredLen)) != '.' && c != '[') {
            return null;
        }
        if (in.target == null) {
            return attrName;
        }
        return in.target + attrName.substring(in.name.length());
    }

    public ScopeData[] lookupScopeData(ActionRequest actionRequest) {
        return actionRequest.getActionConfig().scopeData[this.scopeType.value()];
    }

    public ScopeData.In[] lookupInData(ScopeData[] scopeData) {
        if (scopeData == null) {
            return null;
        }
        ScopeData sd = scopeData[this.scopeType.value()];
        if (sd == null) {
            return null;
        }
        return sd.in;
    }
}

