/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionPathRewriter;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.meta.RenderWith;
import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.Result;
import jodd.petite.meta.PetiteInject;
import jodd.servlet.ServletUtil;
import jodd.typeconverter.TypeConverterManager;

public class MadvocController {
    private static final Logger log = LoggerFactory.getLogger(MadvocController.class);
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected ActionPathRewriter actionPathRewriter;
    @PetiteInject
    protected ResultsManager resultsManager;
    protected ServletContext applicationContext;
    protected Executor executor;

    public void init(ServletContext servletContext) {
        this.applicationContext = servletContext;
        if (this.actionsManager.isAsyncModeOn()) {
            this.executor = this.createAsyncExecutor();
        }
    }

    protected Executor createAsyncExecutor() {
        MadvocConfig.AsyncConfig asyncConfig = this.madvocConfig.getAsyncConfig();
        return new ThreadPoolExecutor(asyncConfig.getCorePoolSize(), asyncConfig.getMaximumPoolSize(), asyncConfig.getKeepAliveTimeMillis(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(asyncConfig.getQueueCapacity()));
    }

    public ServletContext getApplicationContext() {
        return this.applicationContext;
    }

    public String invoke(String actionPath, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        ActionRequest actionRequest = null;
        boolean characterEncodingSet = false;
        while (actionPath != null) {
            String httpMethod;
            ActionConfig actionConfig;
            if (log.isDebugEnabled()) {
                log.debug("Action path: " + actionPath);
            }
            if ((actionConfig = this.actionsManager.lookup(actionPath = this.actionPathRewriter.rewrite(servletRequest, actionPath, httpMethod = servletRequest.getMethod().toUpperCase()), httpMethod)) == null) {
                return actionPath;
            }
            if (log.isDebugEnabled()) {
                log.debug("Invoking action path '" + actionPath + "' using " + actionConfig.actionClass.getSimpleName());
            }
            if (!characterEncodingSet && this.madvocConfig.isApplyCharacterEncoding()) {
                String encoding = this.madvocConfig.getEncoding();
                if (encoding != null) {
                    servletRequest.setCharacterEncoding(encoding);
                    servletResponse.setCharacterEncoding(encoding);
                }
                characterEncodingSet = true;
            }
            Object action = this.createAction(actionConfig.actionClass);
            ActionRequest previousRequest = actionRequest;
            actionRequest = this.createActionRequest(actionPath, actionConfig, action, servletRequest, servletResponse);
            actionRequest.setPreviousActionRequest(previousRequest);
            if (actionConfig.isAsync()) {
                AsyncContext asyncContext = servletRequest.startAsync();
                this.executor.execute(new ActionRequestInvoker(asyncContext, actionRequest));
            } else {
                actionRequest.invoke();
            }
            actionPath = actionRequest.getNextActionPath();
        }
        return null;
    }

    public void render(ActionRequest actionRequest, Object resultObject) throws Exception {
        ActionResult actionResult;
        Result result;
        Class<? extends ActionResult> actionResultClass = null;
        if (resultObject != null && resultObject.getClass() != String.class) {
            RenderWith renderWith = resultObject.getClass().getAnnotation(RenderWith.class);
            if (renderWith != null) {
                actionResultClass = renderWith.value();
            }
        } else if (resultObject == null && (result = actionRequest.getResult()) != null) {
            actionResultClass = result.getActionResult();
            resultObject = result.getResultValue();
            if (resultObject == null) {
                resultObject = result.value();
            }
        }
        if (actionResultClass != null) {
            actionResult = this.resultsManager.lookup(actionResultClass);
            if (actionResult == null) {
                actionResult = this.resultsManager.register(actionResultClass);
            }
        } else {
            int columnIndex;
            String resultValue = resultObject != null ? resultObject.toString() : null;
            String resultType = null;
            if (resultValue != null && (columnIndex = resultValue.indexOf(58)) != -1) {
                resultType = resultValue.substring(0, columnIndex);
                resultValue = resultValue.substring(columnIndex + 1);
            }
            if (resultType == null) {
                resultType = this.madvocConfig.getDefaultResultType();
            }
            if ((actionResult = this.resultsManager.lookup(resultType)) == null) {
                throw new MadvocException("Action result not found: " + resultType);
            }
            try {
                Class targetClass = actionResult.getResultValueType();
                resultObject = targetClass == String.class ? resultValue : TypeConverterManager.convertType((Object)resultValue, targetClass);
            }
            catch (Exception ex) {
                resultObject = resultValue;
            }
        }
        if (this.madvocConfig.isPreventCaching()) {
            ServletUtil.preventCaching((HttpServletResponse)actionRequest.getHttpServletResponse());
        }
        actionResult.render(actionRequest, resultObject);
    }

    protected Object createAction(Class actionClass) {
        try {
            return actionClass.newInstance();
        }
        catch (Exception ex) {
            throw new MadvocException("Invalid Madvoc action", ex);
        }
    }

    protected ActionRequest createActionRequest(String actionPath, ActionConfig actionConfig, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        return new ActionRequest(this, actionPath, actionConfig, action, servletRequest, servletResponse);
    }

    public static class ActionRequestInvoker
    implements Runnable {
        private final ActionRequest actionRequest;
        private final AsyncContext asyncContext;

        public ActionRequestInvoker(AsyncContext asyncContext, ActionRequest actionRequest) {
            this.actionRequest = actionRequest;
            this.asyncContext = asyncContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Async call to: " + this.actionRequest);
                }
                this.actionRequest.invoke();
            }
            catch (Exception ex) {
                log.error("Invoking action path failed: ", (Throwable)ex);
            }
            finally {
                this.asyncContext.complete();
            }
        }
    }
}

