/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import jodd.Jodd;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.paramo.MethodParameter;
import jodd.paramo.Paramo;
import jodd.util.StringUtil;

public class ActionMethodParamNameResolver {
    private static final Logger log = LoggerFactory.getLogger(ActionMethodParamNameResolver.class);

    public String[] resolveParamNames(Method actionClassMethod) {
        String[] names;
        if (!Jodd.isModuleLoaded((int)12)) {
            if (log.isWarnEnabled()) {
                log.warn("Unable to resolve method names, using type short names instead. Add Proxetta to resolve this.");
            }
            names = this.convertTypeNames(actionClassMethod);
        } else {
            MethodParameter[] methodParameters = Paramo.resolveParameters((AccessibleObject)actionClassMethod);
            names = new String[methodParameters.length];
            for (int i = 0; i < methodParameters.length; ++i) {
                names[i] = methodParameters[i].getName();
            }
        }
        return names;
    }

    protected String[] convertTypeNames(Method actionClassMethod) {
        Class<?>[] types = actionClassMethod.getParameterTypes();
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            names[i] = StringUtil.uncapitalize((String)type.getSimpleName());
        }
        return names;
    }
}

