/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import jodd.madvoc.result.ActionResult;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseActionResult<T>
implements ActionResult<T> {
    protected final String resultType;
    protected final Class<T> resultValueType;

    protected BaseActionResult(String resultType) {
        this.resultType = resultType;
        this.resultValueType = this.resolveResultValueType();
    }

    protected BaseActionResult() {
        this.resultType = null;
        this.resultValueType = this.resolveResultValueType();
    }

    protected Class<T> resolveResultValueType() {
        Class<?> clazz = this.getClass();
        while (clazz.getSuperclass() != BaseActionResult.class) {
            Class rvt = ReflectUtil.getGenericSupertype(clazz);
            if (rvt != null) {
                return rvt;
            }
            clazz = clazz.getSuperclass();
        }
        return ReflectUtil.getGenericSupertype(clazz);
    }

    @Override
    public String getResultType() {
        return this.resultType;
    }

    @Override
    public Class<T> getResultValueType() {
        return this.resultValueType;
    }

    @Override
    public void init() {
    }

    public String toString() {
        return "Result: " + this.getClass().getSimpleName() + (this.resultType != null ? ":" + this.resultType : "");
    }
}

