/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jodd.bean.BeanUtil;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.injector.BaseScopeInjector;
import jodd.madvoc.injector.ContextInjector;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Outjector;
import jodd.servlet.CsrfShield;
import jodd.servlet.ServletUtil;
import jodd.servlet.map.HttpServletContextMap;
import jodd.servlet.map.HttpServletRequestMap;
import jodd.servlet.map.HttpSessionMap;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextScopeInjector
extends BaseScopeInjector
implements Injector,
Outjector,
ContextInjector<ServletContext> {
    public static final String REQUEST_NAME = "request";
    public static final String SESSION_NAME = "session";
    public static final String CONTEXT_NAME = "context";
    public static final String REQUEST_MAP = "requestMap";
    public static final String SESSION_MAP = "sessionMap";
    public static final String CONTEXT_MAP = "contextMap";
    public static final String COOKIE_NAME = "cookie";
    public static final String CSRF_NAME = "csrfTokenValid";

    public ServletContextScopeInjector(MadvocConfig madvocConfig, ScopeDataResolver scopeDataResolver) {
        super(ScopeType.SERVLET, madvocConfig, scopeDataResolver);
    }

    @Override
    public void inject(ActionRequest actionRequest) {
        ScopeData.In[][] injectData = this.lookupInData(actionRequest);
        if (injectData == null) {
            return;
        }
        Object[] targets = actionRequest.getTargets();
        HttpServletContextMap servletRequest = actionRequest.getHttpServletRequest();
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        for (int i = 0; i < targets.length; ++i) {
            Object target = targets[i];
            ScopeData.In[] scopes = injectData[i];
            if (scopes == null) continue;
            for (ScopeData.In in : scopes) {
                Class fieldType = in.type;
                Object value = null;
                if (fieldType.equals(HttpServletRequest.class)) {
                    value = servletRequest;
                } else if (fieldType.equals(HttpServletResponse.class)) {
                    value = servletResponse;
                } else if (fieldType.equals(HttpSession.class)) {
                    value = servletRequest.getSession();
                } else if (fieldType.equals(ServletContext.class)) {
                    value = servletRequest.getSession().getServletContext();
                } else if (in.name.equals(REQUEST_MAP)) {
                    value = new HttpServletRequestMap((HttpServletRequest)servletRequest);
                } else if (in.name.equals(SESSION_MAP)) {
                    value = new HttpSessionMap((HttpServletRequest)servletRequest);
                } else if (in.name.equals(CONTEXT_MAP)) {
                    value = new HttpServletContextMap((HttpServletRequest)servletRequest);
                } else if (in.name.startsWith(REQUEST_NAME)) {
                    value = BeanUtil.getDeclaredProperty((Object)servletRequest, (String)StringUtil.uncapitalize((String)in.name.substring(REQUEST_NAME.length())));
                } else if (in.name.startsWith(SESSION_NAME)) {
                    value = BeanUtil.getDeclaredProperty((Object)servletRequest.getSession(), (String)StringUtil.uncapitalize((String)in.name.substring(SESSION_NAME.length())));
                } else if (in.name.startsWith(CONTEXT_NAME)) {
                    value = BeanUtil.getDeclaredProperty((Object)servletRequest.getSession().getServletContext(), (String)StringUtil.uncapitalize((String)in.name.substring(CONTEXT_NAME.length())));
                } else if (in.name.equals(CSRF_NAME)) {
                    value = CsrfShield.checkCsrfToken((HttpServletRequest)servletRequest);
                }
                if (in.name.startsWith(COOKIE_NAME)) {
                    String cookieName = StringUtil.uncapitalize((String)in.name.substring(COOKIE_NAME.length()));
                    if (fieldType.isArray()) {
                        if (fieldType.getComponentType().equals(Cookie.class)) {
                            value = StringUtil.isEmpty((String)cookieName) ? servletRequest.getCookies() : ServletUtil.getAllCookies((HttpServletRequest)servletRequest, (String)cookieName);
                        }
                    } else {
                        value = ServletUtil.getCookie((HttpServletRequest)servletRequest, (String)cookieName);
                    }
                }
                if (value == null) continue;
                String property = in.target != null ? in.target : in.name;
                BeanUtil.setDeclaredProperty((Object)target, (String)property, (Object)value);
            }
        }
    }

    @Override
    public void injectContext(Object target, ScopeData[] scopeData, ServletContext servletContext) {
        ScopeData.In[] injectData = this.lookupInData(scopeData);
        if (injectData == null) {
            return;
        }
        for (ScopeData.In in : injectData) {
            Class fieldType = in.type;
            Object value = null;
            if (fieldType.equals(ServletContext.class)) {
                value = servletContext;
            } else if (in.name.equals(CONTEXT_MAP)) {
                value = new HttpServletContextMap(servletContext);
            } else if (in.name.startsWith(CONTEXT_NAME)) {
                value = BeanUtil.getDeclaredProperty((Object)servletContext, (String)StringUtil.uncapitalize((String)in.name.substring(CONTEXT_NAME.length())));
            }
            if (value == null) continue;
            String property = in.target != null ? in.target : in.name;
            BeanUtil.setDeclaredProperty((Object)target, (String)property, (Object)value);
        }
    }

    @Override
    public void outject(ActionRequest actionRequest) {
        ScopeData.Out[][] outjectData = this.lookupOutData(actionRequest);
        if (outjectData == null) {
            return;
        }
        Object[] targets = actionRequest.getTargets();
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        for (int i = 0; i < targets.length; ++i) {
            Object target = targets[i];
            ScopeData.Out[] scopes = outjectData[i];
            if (scopes == null) continue;
            for (ScopeData.Out out : scopes) {
                Cookie cookie;
                if (!out.name.startsWith(COOKIE_NAME) || (cookie = (Cookie)BeanUtil.getDeclaredProperty((Object)target, (String)out.name)) == null) continue;
                servletResponse.addCookie(cookie);
            }
        }
    }
}

