/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.injector.BaseScopeInjector;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Outjector;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.MultipartRequestWrapper;
import jodd.upload.FileUpload;
import jodd.util.StringUtil;

public class RequestScopeInjector
extends BaseScopeInjector
implements Injector,
Outjector {
    protected final String encoding;
    protected final Config config;
    protected final String attributeMoveId;

    public RequestScopeInjector(MadvocConfig madvocConfig, ScopeDataResolver scopeDataResolver) {
        super(ScopeType.REQUEST, madvocConfig, scopeDataResolver);
        this.encoding = madvocConfig.getEncoding();
        this.config = madvocConfig.getRequestScopeInjectorConfig().clone();
        this.attributeMoveId = madvocConfig.getAttributeMoveId();
    }

    public Config getConfig() {
        return this.config;
    }

    protected void injectAttributes(Object[] targets, ScopeData.In[][] injectData, HttpServletRequest servletRequest) {
        Enumeration attributeNames = servletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            for (int i = 0; i < targets.length; ++i) {
                Object target = targets[i];
                ScopeData.In[] scopes = injectData[i];
                if (scopes == null) continue;
                for (ScopeData.In in : scopes) {
                    String name = this.getMatchedPropertyName(in, attrName);
                    if (name == null) continue;
                    Object attrValue = servletRequest.getAttribute(attrName);
                    this.setTargetProperty(target, name, attrValue);
                }
            }
        }
    }

    protected void injectParameters(Object[] targets, ScopeData.In[][] injectData, HttpServletRequest servletRequest) {
        boolean encode = this.config.encodeGetParams && servletRequest.getMethod().equals("GET");
        Enumeration paramNames = servletRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            for (int i = 0; i < targets.length; ++i) {
                Object target = targets[i];
                ScopeData.In[] scopes = injectData[i];
                if (scopes == null) continue;
                for (ScopeData.In in : scopes) {
                    String name = this.getMatchedPropertyName(in, paramName);
                    if (name == null) continue;
                    String[] paramValues = servletRequest.getParameterValues(paramName);
                    if ((paramValues = ServletUtil.prepareParameters((String[])paramValues, (boolean)this.config.trimParams, (boolean)this.config.treatEmptyParamsAsNull, (boolean)this.config.ignoreEmptyRequestParams)) == null) continue;
                    if (encode) {
                        for (int j = 0; j < paramValues.length; ++j) {
                            String p = paramValues[j];
                            if (p == null) continue;
                            paramValues[j] = StringUtil.convertCharset((String)p, (String)"ISO-8859-1", (String)this.encoding);
                        }
                    }
                    String[] value = paramValues.length != 1 ? paramValues : paramValues[0];
                    this.setTargetProperty(target, name, value);
                }
            }
        }
    }

    protected void injectUploadedFiles(Object[] targets, ScopeData.In[][] injectData, HttpServletRequest servletRequest) {
        if (!(servletRequest instanceof MultipartRequestWrapper)) {
            return;
        }
        MultipartRequestWrapper multipartRequest = (MultipartRequestWrapper)servletRequest;
        if (!multipartRequest.isMultipart()) {
            return;
        }
        Enumeration paramNames = multipartRequest.getFileParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            for (int i = 0; i < targets.length; ++i) {
                Object target = targets[i];
                ScopeData.In[] scopes = injectData[i];
                if (scopes == null) continue;
                for (ScopeData.In in : scopes) {
                    String name = this.getMatchedPropertyName(in, paramName);
                    if (name == null) continue;
                    FileUpload paramValues = multipartRequest.getFiles(paramName);
                    if (this.config.ignoreInvalidUploadFiles) {
                        for (int j = 0; j < ((FileUpload[])paramValues).length; ++j) {
                            FileUpload paramValue = paramValues[j];
                            if (paramValue.isValid() && paramValue.isUploaded()) continue;
                            paramValues[j] = null;
                        }
                    }
                    FileUpload value = ((FileUpload[])paramValues).length == 1 ? paramValues[0] : paramValues;
                    this.setTargetProperty(target, name, value);
                }
            }
        }
    }

    protected void outjectMoveSource(ActionRequest actionRequest) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        String moveId = servletRequest.getParameter(this.attributeMoveId);
        if (moveId != null) {
            HttpSession session = servletRequest.getSession();
            ActionRequest sourceRequest = (ActionRequest)session.getAttribute(moveId);
            session.removeAttribute(moveId);
            if (sourceRequest != null) {
                this.outjectAfterMove(sourceRequest);
            }
        }
    }

    public void prepare(ActionRequest actionRequest) {
        this.outjectMoveSource(actionRequest);
    }

    public void inject(ActionRequest actionRequest) {
        Object[] targets = actionRequest.getTargets();
        ScopeData.In[][] injectData = this.lookupInData(actionRequest);
        if (injectData == null) {
            return;
        }
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        if (this.config.injectAttributes) {
            this.injectAttributes(targets, injectData, servletRequest);
        }
        if (this.config.injectParameters) {
            this.injectParameters(targets, injectData, servletRequest);
            this.injectUploadedFiles(targets, injectData, servletRequest);
        }
    }

    public void outject(ActionRequest actionRequest) {
        ScopeData.Out[][] outjectData = this.lookupOutData(actionRequest);
        if (outjectData == null) {
            return;
        }
        Object[] targets = actionRequest.getTargets();
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        for (int i = 0; i < targets.length; ++i) {
            Object target = targets[i];
            ScopeData.Out[] scopes = outjectData[i];
            if (scopes == null) continue;
            for (ScopeData.Out out : scopes) {
                Object value = this.getTargetProperty(target, out);
                servletRequest.setAttribute(out.name, value);
            }
        }
    }

    protected void outjectAfterMove(ActionRequest sourceRequest) {
        ScopeData.Out[][] outjectData = this.lookupOutData(sourceRequest);
        if (outjectData == null) {
            return;
        }
        Object[] targets = sourceRequest.getTargets();
        HttpServletRequest servletRequest = sourceRequest.getHttpServletRequest();
        for (int i = 0; i < targets.length; ++i) {
            Object target = targets[i];
            ScopeData.Out[] scopes = outjectData[i];
            if (scopes == null) continue;
            for (ScopeData.Out out : scopes) {
                Object value = this.getTargetProperty(target, out);
                servletRequest.setAttribute(out.name, value);
            }
        }
    }

    public static class Config
    implements Cloneable {
        protected boolean ignoreEmptyRequestParams;
        protected boolean treatEmptyParamsAsNull;
        protected boolean injectAttributes = true;
        protected boolean injectParameters = true;
        protected boolean trimParams;
        protected boolean encodeGetParams;
        protected boolean ignoreInvalidUploadFiles = true;

        public boolean isIgnoreEmptyRequestParams() {
            return this.ignoreEmptyRequestParams;
        }

        public void setIgnoreEmptyRequestParams(boolean ignoreEmptyRequestParams) {
            this.ignoreEmptyRequestParams = ignoreEmptyRequestParams;
        }

        public boolean isTreatEmptyParamsAsNull() {
            return this.treatEmptyParamsAsNull;
        }

        public void setTreatEmptyParamsAsNull(boolean treatEmptyParamsAsNull) {
            this.treatEmptyParamsAsNull = treatEmptyParamsAsNull;
        }

        public boolean isInjectAttributes() {
            return this.injectAttributes;
        }

        public void setInjectAttributes(boolean injectAttributes) {
            this.injectAttributes = injectAttributes;
        }

        public boolean isInjectParameters() {
            return this.injectParameters;
        }

        public void setInjectParameters(boolean injectParameters) {
            this.injectParameters = injectParameters;
        }

        public boolean isTrimParams() {
            return this.trimParams;
        }

        public void setTrimParams(boolean trimParams) {
            this.trimParams = trimParams;
        }

        public boolean isEncodeGetParams() {
            return this.encodeGetParams;
        }

        public void setEncodeGetParams(boolean encodeGetParams) {
            this.encodeGetParams = encodeGetParams;
        }

        public boolean isIgnoreInvalidUploadFiles() {
            return this.ignoreInvalidUploadFiles;
        }

        public void setIgnoreInvalidUploadFiles(boolean ignoreInvalidUploadFiles) {
            this.ignoreInvalidUploadFiles = ignoreInvalidUploadFiles;
        }

        public Config clone() {
            try {
                return (Config)super.clone();
            }
            catch (CloneNotSupportedException cnsex) {
                throw new MadvocException(cnsex);
            }
        }
    }
}

