/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import jodd.bean.BeanUtil;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ScopeDataResolver;

public abstract class BaseScopeInjector {
    private static final Logger log = LoggerFactory.getLogger(BaseScopeInjector.class);
    protected final ScopeDataResolver scopeDataResolver;
    protected final ScopeType scopeType;
    protected final MadvocConfig madvocConfig;

    protected BaseScopeInjector(ScopeType scopeType, MadvocConfig madvocConfig, ScopeDataResolver scopeDataResolver) {
        this.scopeType = scopeType;
        this.madvocConfig = madvocConfig;
        this.scopeDataResolver = scopeDataResolver;
    }

    protected void setTargetProperty(Object target, String name, Object attrValue) {
        block4: {
            if (BeanUtil.hasDeclaredRootProperty((Object)target, (String)name)) {
                try {
                    BeanUtil.setDeclaredPropertyForced((Object)target, (String)name, (Object)attrValue);
                }
                catch (Exception ex) {
                    if (this.madvocConfig.isInjectionErrorThrowsException()) {
                        throw new MadvocException(ex);
                    }
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Injection failed: " + name + ". " + ex.toString());
                }
            }
        }
    }

    protected Object getTargetProperty(Object target, ScopeData.Out out) {
        if (out.target == null) {
            return BeanUtil.getDeclaredProperty((Object)target, (String)out.name);
        }
        return BeanUtil.getDeclaredProperty((Object)target, (String)out.target);
    }

    protected String getMatchedPropertyName(ScopeData.In in, String attrName) {
        char c;
        if (!attrName.startsWith(in.name)) {
            return null;
        }
        int requiredLen = in.name.length();
        if (attrName.length() >= requiredLen + 1 && (c = attrName.charAt(requiredLen)) != '.' && c != '[') {
            return null;
        }
        if (in.target == null) {
            return attrName;
        }
        return in.target + attrName.substring(in.name.length());
    }

    public ScopeData.In[] lookupInData(ScopeData[] scopeData) {
        if (scopeData == null) {
            return null;
        }
        ScopeData sd = scopeData[this.scopeType.value()];
        if (sd == null) {
            return null;
        }
        return sd.in;
    }

    public ScopeData.In[][] lookupInData(ActionRequest actionRequest) {
        return actionRequest.getActionConfig().ins[this.scopeType.value()];
    }

    public ScopeData.Out[][] lookupOutData(ActionRequest actionRequest) {
        return actionRequest.getActionConfig().outs[this.scopeType.value()];
    }
}

