/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import java.lang.reflect.Method;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.config.MadvocConfigurator;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManualMadvocConfigurator
implements MadvocConfigurator {
    public static final String NONE = "#";
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected ActionMethodParser actionMethodParser;
    @PetiteInject
    protected ResultsManager resultsManager;

    public void result(Class<? extends ActionResult> resultClass) {
        this.resultsManager.register(resultClass);
    }

    public ActionBuilder action() {
        return new ActionBuilder();
    }

    public class ActionBuilder {
        String method;
        String actionPath;
        Class actionClass;
        Method actionClassMethod;
        String actionMethodString;
        String alias;
        ActionFilter[] actionFilters;
        ActionInterceptor[] actionInterceptors;
        boolean async;

        public ActionBuilder path(String path) {
            this.actionPath = path;
            return this;
        }

        public ActionBuilder path(String method, String path) {
            this.method = method;
            return this.path(path);
        }

        public ActionBuilder mapTo(Class actionClass, Method actionMethod) {
            this.actionClass = actionClass;
            this.actionClassMethod = actionMethod;
            this.actionMethodString = null;
            return this;
        }

        public ActionBuilder mapTo(Method actionMethod) {
            this.actionClass = actionMethod.getDeclaringClass();
            this.actionClassMethod = actionMethod;
            this.actionMethodString = null;
            return this;
        }

        public ActionBuilder mapTo(Class actionClass, String actionMethodName) {
            this.actionClass = actionClass;
            this.actionClassMethod = null;
            this.actionMethodString = actionMethodName;
            return this;
        }

        public ActionBuilder interceptedBy(ActionInterceptor ... interceptors) {
            this.actionInterceptors = interceptors;
            return this;
        }

        public ActionBuilder filtereBy(ActionFilter ... filters) {
            this.actionFilters = filters;
            return this;
        }

        public ActionBuilder alias(String aliasPath) {
            this.alias = aliasPath;
            return this;
        }

        public ActionBuilder async(boolean async) {
            this.async = async;
            return this;
        }

        public void bind() {
            if (this.actionMethodString != null) {
                this.actionClassMethod = ManualMadvocConfigurator.this.actionMethodParser.resolveActionMethod(this.actionClass, this.actionMethodString);
            }
            ActionConfig actionConfig = ManualMadvocConfigurator.this.actionMethodParser.createActionConfig(this.actionClass, this.actionClassMethod, this.actionFilters, this.actionInterceptors, this.actionPath, this.method, this.async, null);
            ManualMadvocConfigurator.this.actionsManager.registerAction(actionConfig);
            if (this.alias != null) {
                ManualMadvocConfigurator.this.actionsManager.registerPathAlias(this.actionPath, this.alias);
            }
        }
    }
}

