/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsManager {
    private static final Logger log = LoggerFactory.getLogger(ResultsManager.class);
    @PetiteInject
    protected ContextInjectorComponent contextInjectorComponent;
    protected final Map<String, ActionResult> stringResults = new HashMap<String, ActionResult>();
    protected final Map<Class<? extends ActionResult>, ActionResult> allResults = new HashMap<Class<? extends ActionResult>, ActionResult>();

    public Set<ActionResult> getAllActionResults() {
        HashSet<ActionResult> set = new HashSet<ActionResult>(this.stringResults.size() + this.allResults.size());
        set.addAll(this.stringResults.values());
        set.addAll(this.allResults.values());
        return set;
    }

    public ActionResult register(Class<? extends ActionResult> resultClass) {
        return this.register(this.createResult(resultClass));
    }

    public ActionResult register(ActionResult result) {
        String resultType = result.getResultType();
        boolean existingResult = false;
        if (resultType != null) {
            ActionResult existing = this.lookup(resultType);
            if (existing != null) {
                Class<?> resultClass = result.getClass();
                Class<?> existingClass = existing.getClass();
                if (!existingClass.equals(resultClass)) {
                    if (resultClass.getPackage().equals(ActionResult.class.getPackage())) {
                        Class<?> temp = existingClass;
                        existingClass = resultClass;
                        resultClass = temp;
                        result = this.lookup(resultClass);
                        existingResult = true;
                    }
                    if (!existingClass.getPackage().equals(ActionResult.class.getPackage())) {
                        throw new MadvocException("Duplicate result: " + result);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(existingClass.getSimpleName() + " result replaced with " + resultClass.getSimpleName());
                    }
                }
                this.allResults.remove(existingClass);
            }
            this.stringResults.put(result.getResultType(), result);
        }
        this.allResults.put(result.getClass(), result);
        if (!existingResult) {
            this.initializeResult(result);
        }
        return result;
    }

    public ActionResult lookup(Class<? extends ActionResult> resultClass) {
        return this.allResults.get(resultClass);
    }

    public ActionResult lookup(String resultType) {
        return this.stringResults.get(resultType);
    }

    protected void initializeResult(ActionResult result) {
        this.contextInjectorComponent.injectContext(result);
        result.init();
    }

    protected ActionResult createResult(Class<? extends ActionResult> actionResultClass) {
        try {
            return actionResultClass.newInstance();
        }
        catch (Exception ex) {
            throw new MadvocException("Invalid Madvoc result: " + actionResultClass, ex);
        }
    }
}

