/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.Method;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.MethodDescriptor;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.RootPackages;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.ActionAnnotation;
import jodd.madvoc.meta.ActionAnnotationData;
import jodd.madvoc.meta.FilteredBy;
import jodd.madvoc.meta.InterceptedBy;
import jodd.madvoc.meta.MadvocAction;
import jodd.petite.meta.PetiteInject;
import jodd.util.AnnotationDataReader;
import jodd.util.ArraysUtil;
import jodd.util.ClassLoaderUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMethodParser {
    protected static final String REPL_PACKAGE = "[package]";
    protected static final String REPL_CLASS = "[class]";
    protected static final String REPL_METHOD = "[method]";
    protected static final String REPL_EXTENSION = "[ext]";
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected InterceptorsManager interceptorsManager;
    @PetiteInject
    protected FiltersManager filtersManager;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ScopeDataResolver scopeDataResolver;

    public Method resolveActionMethod(Class<?> actionClass, String methodName) {
        MethodDescriptor methodDescriptor = ClassIntrospector.lookup(actionClass).getMethodDescriptor(methodName, false);
        if (methodDescriptor == null) {
            throw new MadvocException("Action class '" + actionClass.getSimpleName() + "' doesn't have public method: " + methodName);
        }
        return methodDescriptor.getMethod();
    }

    public ActionConfig parse(Class<?> actionClass, Method actionMethod) {
        return this.parse(actionClass, actionMethod, null);
    }

    public ActionConfig parse(Class<?> actionClass, String actionMethodName, String actionPath) {
        Method method = this.resolveActionMethod(actionClass, actionMethodName);
        return this.parse(actionClass, method, actionPath);
    }

    public ActionConfig parse(Class<?> actionClass, Method actionMethod, String actionPath) {
        ActionAnnotation<?> actionAnnotation;
        Class[] interceptorClasses = this.readMethodInterceptors(actionMethod);
        if (interceptorClasses == null) {
            interceptorClasses = this.readClassInterceptors(actionClass);
        }
        if (interceptorClasses == null) {
            interceptorClasses = this.madvocConfig.getDefaultInterceptors();
        }
        ActionInterceptor[] actionInterceptors = (ActionInterceptor[])this.interceptorsManager.resolveAll(interceptorClasses);
        Class[] filterClasses = this.readMethodFilters(actionMethod);
        if (filterClasses == null) {
            filterClasses = this.readClassFilters(actionClass);
        }
        if (filterClasses == null) {
            filterClasses = this.madvocConfig.getDefaultFilters();
        }
        ActionFilter[] actionFilters = (ActionFilter[])this.filtersManager.resolveAll(filterClasses);
        String[] actionPathElements = new String[4];
        String packageActionPath = this.readPackageActionPath(actionClass, actionPathElements);
        String classActionPath = this.readClassActionPath(actionClass, actionPathElements);
        if (classActionPath == null) {
            return null;
        }
        AnnotationDataReader.AnnotationData annotationData = null;
        ActionAnnotation<?>[] arr$ = this.madvocConfig.getActionAnnotationInstances();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (annotationData = (actionAnnotation = arr$[i$]).readAnnotationData(actionMethod)) == null; ++i$) {
        }
        String actionMethodName = actionMethod.getName();
        String methodActionPath = this.readMethodActionPath(actionMethodName, (ActionAnnotationData)annotationData, actionPathElements);
        String extension = this.readMethodExtension((ActionAnnotationData)annotationData);
        String alias = this.readMethodAlias((ActionAnnotationData)annotationData);
        String httpMethod = this.readMethodHttpMethod((ActionAnnotationData)annotationData);
        boolean async = this.readMethodAsyncFlag((ActionAnnotationData)annotationData);
        if (methodActionPath != null) {
            actionPathElements[3] = extension;
            for (String path : this.madvocConfig.getDefaultActionMethodNames()) {
                if (!methodActionPath.equals(path)) continue;
                methodActionPath = null;
                break;
            }
        }
        if (actionPath == null) {
            actionPath = this.buildActionPath(packageActionPath, classActionPath, methodActionPath, extension, httpMethod);
        }
        actionPath = StringUtil.replace((String)actionPath, (String)REPL_PACKAGE, (String)actionPathElements[0]);
        actionPath = StringUtil.replace((String)actionPath, (String)REPL_CLASS, (String)actionPathElements[1]);
        actionPath = StringUtil.replace((String)actionPath, (String)REPL_METHOD, (String)actionPathElements[2]);
        actionPath = StringUtil.replace((String)actionPath, (String)REPL_EXTENSION, (String)actionPathElements[3]);
        if (alias != null) {
            String aliasPath = StringUtil.cutToIndexOf((String)actionPath, (String)"#");
            this.actionsManager.registerPathAlias(alias, aliasPath);
        }
        return this.createActionConfig(actionClass, actionMethod, actionFilters, actionInterceptors, actionPath, httpMethod, async, actionPathElements);
    }

    protected String buildActionPath(String packageActionPath, String classActionPath, String methodActionPath, String extension, String httpMethod) {
        String pathSeparator = "/";
        String actionPath = classActionPath;
        if (methodActionPath != null) {
            if (methodActionPath.startsWith(pathSeparator)) {
                return methodActionPath;
            }
            if (extension != null) {
                methodActionPath = methodActionPath + '.' + extension;
            }
            if (!classActionPath.endsWith(pathSeparator)) {
                actionPath = actionPath + ".";
            }
            actionPath = actionPath + methodActionPath;
        } else if (extension != null) {
            actionPath = actionPath + '.' + extension;
        }
        if (actionPath.startsWith(pathSeparator)) {
            return actionPath;
        }
        actionPath = packageActionPath != null ? packageActionPath + actionPath : pathSeparator + actionPath;
        return actionPath;
    }

    protected Class<? extends ActionInterceptor>[] readClassInterceptors(Class actionClass) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionClass.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionInterceptor>[] readMethodInterceptors(Method actionMethod) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionMethod.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionFilter>[] readClassFilters(Class actionClass) {
        Class<? extends ActionFilter>[] result = null;
        FilteredBy filteredBy = actionClass.getAnnotation(FilteredBy.class);
        if (filteredBy != null && (result = filteredBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionFilter>[] readMethodFilters(Method actionMethod) {
        Class<? extends ActionFilter>[] result = null;
        FilteredBy filteredBy = actionMethod.getAnnotation(FilteredBy.class);
        if (filteredBy != null && (result = filteredBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected String readPackageActionPath(Class actionClass, String[] actionPathElements) {
        MadvocAction madvocActionAnnotation;
        String packageActionPath;
        Package actionPackage = actionClass.getPackage();
        String actionPackageName = actionPackage.getName();
        RootPackages rootPackages = this.madvocConfig.getRootPackages();
        String packagePath = rootPackages.getPackageActionPath(actionPackageName);
        if (packagePath == null) {
            packagePath = rootPackages.findPackagePathForActionPackage(actionPackageName);
            String rootPackage = null;
            if (packagePath != null) {
                rootPackage = rootPackages.findRootPackageForActionPath(packagePath);
            }
            String packageName = actionPackageName;
            String madvocRootPackageClassName = this.madvocConfig.getMadvocRootPackageClassName();
            if (madvocRootPackageClassName != null) {
                while (true) {
                    String className = packageName + '.' + madvocRootPackageClassName;
                    try {
                        Class madvocRootPackageClass = ClassLoaderUtil.loadClass((String)className, (ClassLoader)actionClass.getClassLoader());
                        String mapping = "";
                        MadvocAction madvocAction = madvocRootPackageClass.getAnnotation(MadvocAction.class);
                        if (madvocAction != null) {
                            mapping = madvocAction.value();
                        }
                        this.madvocConfig.getRootPackages().addRootPackage(packageName, mapping);
                        packagePath = rootPackages.findPackagePathForActionPackage(actionPackageName);
                    }
                    catch (ClassNotFoundException ignore) {
                        int dotNdx = packageName.lastIndexOf(46);
                        if (dotNdx != -1) {
                            packageName = packageName.substring(0, dotNdx);
                            if (rootPackage == null || !packageName.equals(rootPackage)) continue;
                        }
                    }
                    break;
                }
            }
            rootPackages.registerPackageActionPath(actionPackageName, packagePath);
        }
        String string = packageActionPath = (madvocActionAnnotation = actionPackage.getAnnotation(MadvocAction.class)) != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty((String)packageActionPath)) {
            packageActionPath = null;
        }
        if (packageActionPath == null) {
            if (packagePath == null) {
                return null;
            }
            packageActionPath = packagePath;
        }
        actionPathElements[0] = StringUtil.stripChar((String)packagePath, (char)'/');
        return StringUtil.surround((String)packageActionPath, (String)"/");
    }

    protected String readClassActionPath(Class actionClass, String[] actionPathElements) {
        String classActionPath;
        MadvocAction madvocActionAnnotation = actionClass.getAnnotation(MadvocAction.class);
        String string = classActionPath = madvocActionAnnotation != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty((String)classActionPath)) {
            classActionPath = null;
        }
        String name = actionClass.getSimpleName();
        name = StringUtil.uncapitalize((String)name);
        name = MadvocUtil.stripLastCamelWord(name);
        if (classActionPath == null) {
            classActionPath = name;
        }
        actionPathElements[1] = name;
        return classActionPath;
    }

    protected String readMethodActionPath(String methodName, ActionAnnotationData annotationData, String[] actionPathElements) {
        String methodActionPath;
        String string = methodActionPath = annotationData != null ? annotationData.getValue() : null;
        if (methodActionPath == null) {
            methodActionPath = methodName;
        } else if (methodActionPath.equals("#")) {
            return null;
        }
        actionPathElements[2] = methodName;
        return methodActionPath;
    }

    protected String readMethodExtension(ActionAnnotationData annotationData) {
        String annExtension;
        String extension = this.madvocConfig.getDefaultExtension();
        if (annotationData != null && (annExtension = annotationData.getExtension()) != null) {
            extension = annExtension.equals("#") ? null : StringUtil.replace((String)annExtension, (String)REPL_EXTENSION, (String)extension);
        }
        return extension;
    }

    protected String readMethodAlias(ActionAnnotationData annotationData) {
        String alias = null;
        if (annotationData != null) {
            alias = annotationData.getAlias();
        }
        return alias;
    }

    private String readMethodHttpMethod(ActionAnnotationData annotationData) {
        String method = null;
        if (annotationData != null) {
            method = annotationData.getMethod();
        }
        return method;
    }

    private boolean readMethodAsyncFlag(ActionAnnotationData annotationData) {
        boolean sync = false;
        if (annotationData != null) {
            sync = annotationData.isAsync();
        }
        return sync;
    }

    public ActionConfig createActionConfig(Class actionClass, Method actionClassMethod, ActionFilter[] filters, ActionInterceptor[] interceptors, String actionPath, String actionMethod, boolean async, String[] pathElements) {
        if (actionMethod != null) {
            actionMethod = actionMethod.toUpperCase();
        }
        Object[] paramTypes = actionClassMethod.getParameterTypes();
        Class[] types = (Class[])ArraysUtil.insert((Object[])paramTypes, (Object)actionClass, (int)0);
        ScopeData.In[][][] ins = new ScopeData.In[ScopeType.values().length][][];
        ScopeData.Out[][][] outs = new ScopeData.Out[ScopeType.values().length][][];
        for (int i = 0; i < ScopeType.values().length; ++i) {
            ins[i] = new ScopeData.In[types.length][];
            outs[i] = new ScopeData.Out[types.length][];
            for (int j = 0; j < types.length; ++j) {
                Class type = types[j];
                ScopeData[] scopeData = this.scopeDataResolver.resolveScopeData(type);
                if (scopeData == null || scopeData[i] == null) continue;
                ins[i][j] = scopeData[i].in;
                outs[i][j] = scopeData[i].out;
            }
        }
        return new ActionConfig(actionClass, actionClassMethod, filters, interceptors, actionPath, actionMethod, async, ins, outs, pathElements);
    }
}

