/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.exception.ExceptionUtil;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.Result;

public class ActionRequest {
    protected final MadvocController madvocController;
    protected final ActionConfig actionConfig;
    protected final String actionPath;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected Result result;
    protected final Object[] params;
    protected final Object[] targets;
    protected final int totalInterceptors;
    protected int interceptorIndex;
    protected int filterIndex;
    protected int totalFilters;
    protected int execState;
    protected Object action;
    protected String nextActionPath;
    protected ActionRequest previousActionRequest;

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        this.servletResponse = response;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }

    public Object getAction() {
        return this.action;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public String getNextActionPath() {
        return this.nextActionPath;
    }

    public void setNextActionPath(String nextActionPath) {
        this.nextActionPath = nextActionPath;
    }

    public ActionRequest getPreviousActionRequest() {
        return this.previousActionRequest;
    }

    public void setPreviousActionRequest(ActionRequest previousActionRequest) {
        this.previousActionRequest = previousActionRequest;
    }

    public Result getResult() {
        return this.result;
    }

    public Object[] getTargets() {
        return this.targets;
    }

    public ActionRequest(MadvocController madvocController, String actionPath, ActionConfig actionConfig, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.madvocController = madvocController;
        this.actionPath = actionPath;
        this.actionConfig = actionConfig;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.totalInterceptors = this.actionConfig.interceptors != null ? this.actionConfig.interceptors.length : 0;
        this.interceptorIndex = 0;
        this.totalFilters = this.actionConfig.filters != null ? this.actionConfig.filters.length : 0;
        this.filterIndex = 0;
        this.execState = 0;
        this.action = action;
        this.result = this.findResult();
        this.params = this.createActionMethodArguments();
        this.targets = this.makeTargets();
    }

    protected Object[] makeTargets() {
        if (this.params == null) {
            return new Object[]{this.action};
        }
        Object[] target = new Object[this.params.length + 1];
        target[0] = this.action;
        System.arraycopy(this.params, 0, target, 1, this.params.length);
        return target;
    }

    protected Result findResult() {
        Field resultField = this.actionConfig.resultField;
        if (resultField != null) {
            try {
                Result result = (Result)resultField.get(this.action);
                if (result == null) {
                    result = (Result)resultField.getType().newInstance();
                    resultField.set(this.action, result);
                }
                return result;
            }
            catch (Exception ignore) {
                return null;
            }
        }
        return null;
    }

    protected Object[] createActionMethodArguments() {
        if (!this.actionConfig.hasArguments) {
            return null;
        }
        Class<?>[] types = this.actionConfig.getActionClassMethod().getParameterTypes();
        Object[] params = new Object[types.length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> type = types[i];
            try {
                Constructor<?> ctor;
                if (type.getEnclosingClass() == null || Modifier.isStatic(type.getModifiers())) {
                    ctor = type.getDeclaredConstructor(null);
                    ctor.setAccessible(true);
                    params[i] = ctor.newInstance(new Object[0]);
                    continue;
                }
                ctor = type.getDeclaredConstructor(this.actionConfig.getActionClass());
                ctor.setAccessible(true);
                params[i] = ctor.newInstance(this.action);
                continue;
            }
            catch (Exception ex) {
                throw new MadvocException(ex);
            }
        }
        return params;
    }

    public Object invoke() throws Exception {
        Object actionResult;
        if (this.execState >= 2) {
            throw new MadvocException("Action already invoked: " + this.actionConfig.actionPath);
        }
        if (this.execState == 0 && this.filterIndex < this.totalFilters) {
            ActionFilter filter = this.actionConfig.filters[this.filterIndex];
            ++this.filterIndex;
            return filter.invoke(this);
        }
        this.execState = 1;
        try {
            actionResult = this.invokeAction();
        }
        catch (Exception ex) {
            --this.interceptorIndex;
            throw ex;
        }
        if (this.execState == 2) {
            if (this.interceptorIndex > 0) {
                --this.interceptorIndex;
            } else {
                this.madvocController.render(this, actionResult);
                this.execState = 3;
            }
        } else if (this.execState == 1) {
            if (this.interceptorIndex > 1) {
                --this.interceptorIndex;
            } else {
                this.madvocController.render(this, actionResult);
                this.execState = 3;
            }
        }
        return actionResult;
    }

    protected Object invokeAction() throws Exception {
        if (this.interceptorIndex < this.totalInterceptors) {
            ActionInterceptor interceptor = this.actionConfig.interceptors[this.interceptorIndex];
            ++this.interceptorIndex;
            return interceptor.invoke(this);
        }
        this.execState = 2;
        return this.invokeActionMethod();
    }

    protected Object invokeActionMethod() throws Exception {
        try {
            return this.actionConfig.actionClassMethod.invoke(this.action, this.params);
        }
        catch (InvocationTargetException itex) {
            throw ExceptionUtil.extractTargetException((InvocationTargetException)itex);
        }
    }
}

