/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.madvoc.ActionConfigSet;
import jodd.madvoc.ScopeData;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.Result;
import jodd.util.ReflectUtil;

public class ActionConfig {
    public final Class actionClass;
    public final Method actionClassMethod;
    public final String actionPath;
    public final String actionMethod;
    public final Field resultField;
    public final boolean async;
    public final ScopeData.In[][][] ins;
    public final ScopeData.Out[][][] outs;
    public final boolean hasArguments;
    protected ActionConfigSet actionConfigSet;
    public final ActionFilter[] filters;
    public final ActionInterceptor[] interceptors;

    public ActionConfig(Class actionClass, Method actionClassMethod, ActionFilter[] filters, ActionInterceptor[] interceptors, String actionPath, String actionMethod, boolean async, ScopeData.In[][][] ins, ScopeData.Out[][][] outs, String[] actionPathElements) {
        this.actionClass = actionClass;
        this.actionClassMethod = actionClassMethod;
        this.actionPath = actionPath;
        this.actionMethod = actionMethod;
        this.hasArguments = actionClassMethod.getParameterTypes().length != 0;
        this.async = async;
        this.ins = ins;
        this.outs = outs;
        this.filters = filters;
        this.interceptors = interceptors;
        this.resultField = this.findResultField(actionClass);
    }

    protected Field findResultField(Class actionClass) {
        FieldDescriptor[] fields;
        for (FieldDescriptor fd : fields = ClassIntrospector.lookup((Class)actionClass).getAllFieldDescriptors()) {
            Field field = fd.getField();
            if (!ReflectUtil.isSubclass(field.getType(), Result.class)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    public Class getActionClass() {
        return this.actionClass;
    }

    public Method getActionClassMethod() {
        return this.actionClassMethod;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public String getActionMethod() {
        return this.actionMethod;
    }

    public ActionInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public boolean isAsync() {
        return this.async;
    }

    public ActionConfigSet getActionConfigSet() {
        return this.actionConfigSet;
    }

    public String getActionString() {
        return this.actionClass.getName() + '#' + this.actionClassMethod.getName();
    }

    public String toString() {
        return "action: " + this.actionPath + (this.actionMethod == null ? "" : '#' + this.actionMethod) + "  -->  " + this.getActionString();
    }
}

