/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.interceptor.ActionInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatedFieldsInterceptor
extends ActionInterceptor {
    protected final Class<Annotation> fieldAnnotation;
    protected Map<Class<?>, Field[]> annotatedField = new HashMap();
    protected static final Field[] EMPTY_FIELD = new Field[0];

    protected AnnotatedFieldsInterceptor(Class<Annotation> fieldAnnotation) {
        this.fieldAnnotation = fieldAnnotation;
    }

    @Override
    public Object intercept(ActionRequest actionRequest) throws Exception {
        Field[] fields;
        Object action = actionRequest.getAction();
        Class<?> actionType = action.getClass();
        for (Field field : fields = this.lookupAnnotatedFields(actionType)) {
            this.onAnnotatedField(actionRequest, field);
        }
        return actionRequest.invoke();
    }

    protected abstract void onAnnotatedField(ActionRequest var1, Field var2);

    protected Field[] lookupAnnotatedFields(Class type) {
        Field[] fields = this.annotatedField.get(type);
        if (fields == null) {
            ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
            FieldDescriptor[] allFields = cd.getAllFieldDescriptors();
            ArrayList<Field> fieldlist = new ArrayList<Field>();
            for (FieldDescriptor fieldDescriptor : allFields) {
                Field field = fieldDescriptor.getField();
                Annotation ann = field.getAnnotation(this.fieldAnnotation);
                if (ann == null) continue;
                fieldlist.add(field);
            }
            fields = fieldlist.isEmpty() ? EMPTY_FIELD : fieldlist.toArray(new Field[fieldlist.size()]);
            this.annotatedField.put(type, fields);
        }
        return fields;
    }
}

