/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.madvoc.MadvocException;
import jodd.madvoc.ScopeType;
import jodd.madvoc.injector.ScopeData;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.InOut;
import jodd.madvoc.meta.Out;
import jodd.util.ReflectUtil;

public class ScopeDataResolver {
    private static final ScopeData[] EMPTY_SCOPEDATA = new ScopeData[0];
    protected Map<Object, ScopeData[]> scopeMap = new HashMap<Object, ScopeData[]>();

    public ScopeData.In[] lookupInData(Class actionClass, ScopeType scopeType) {
        return this.lookupIn(actionClass, scopeType);
    }

    protected ScopeData.In[] lookupIn(Object key, ScopeType scopeType) {
        ScopeData[] scopeData = this.scopeMap.get(key);
        if (scopeData == null) {
            scopeData = this.inspectAllScopeData(key);
        }
        if (scopeData.length == 0) {
            return null;
        }
        ScopeData sd = scopeData[scopeType.value()];
        if (sd == null) {
            return null;
        }
        return sd.in;
    }

    public ScopeData.Out[] lookupOutData(Class actionClass, ScopeType scopeType) {
        ScopeData[] scopeData = this.scopeMap.get(actionClass);
        if (scopeData == null) {
            scopeData = this.inspectAllScopeData(actionClass);
        }
        if (scopeData.length == 0) {
            return null;
        }
        ScopeData sd = scopeData[scopeType.value()];
        if (sd == null) {
            return null;
        }
        return sd.out;
    }

    protected ScopeData[] inspectAllScopeData(Object key) {
        ScopeType[] allScopeTypes = ScopeType.values();
        ScopeData[] scopeData = new ScopeData[allScopeTypes.length];
        int count = 0;
        if (key instanceof Class) {
            for (ScopeType st : allScopeTypes) {
                ScopeData sd = this.inspectScopeData((Class)key, st);
                if (sd != null) {
                    ++count;
                }
                scopeData[st.value()] = sd;
            }
        } else {
            throw new MadvocException("IN data are available only for Class.");
        }
        if (count == 0) {
            scopeData = EMPTY_SCOPEDATA;
        }
        this.scopeMap.put(key, scopeData);
        return scopeData;
    }

    protected void fillNameTarget(ScopeData.In ii, String value, String propertyName) {
        if ((value = value.trim()).length() > 0) {
            ii.name = value;
            ii.target = propertyName;
        } else {
            ii.name = propertyName;
            ii.target = null;
        }
    }

    protected void fillNameTarget(ScopeData.Out oi, String value, String propertyName) {
        if ((value = value.trim()).length() > 0) {
            oi.name = value;
            oi.target = propertyName;
        } else {
            oi.name = propertyName;
            oi.target = null;
        }
    }

    protected ScopeData.In inspectIn(In in, ScopeType scopeType, String propertyName, Class propertyType) {
        if (in == null) {
            return null;
        }
        ScopeType scope = in.scope();
        if (scope != scopeType) {
            return null;
        }
        ScopeData.In ii = new ScopeData.In();
        this.fillNameTarget(ii, in.value(), propertyName);
        ii.type = propertyType;
        ii.create = in.create();
        ii.remove = in.remove();
        return ii;
    }

    protected ScopeData.In defaultRequestScopeIn(ScopeType scopeType, String paramName, Class propertyType) {
        if (scopeType != ScopeType.REQUEST) {
            return null;
        }
        ScopeData.In ii = new ScopeData.In();
        ii.name = paramName;
        ii.target = null;
        ii.type = propertyType;
        ii.create = false;
        ii.remove = false;
        return ii;
    }

    protected ScopeData.In inspectIn(InOut inOut, ScopeType scopeType, String propertyName, Class propertyType) {
        if (inOut == null) {
            return null;
        }
        ScopeType scope = inOut.scope();
        if (scope != scopeType) {
            return null;
        }
        ScopeData.In ii = new ScopeData.In();
        this.fillNameTarget(ii, inOut.value(), propertyName);
        ii.type = propertyType;
        ii.create = inOut.create();
        ii.remove = inOut.remove();
        return ii;
    }

    protected ScopeData.Out inspectOut(Out out, ScopeType scopeType, String propertyName, Class propertyType) {
        if (out == null) {
            return null;
        }
        ScopeType scope = out.scope();
        if (scope != scopeType) {
            return null;
        }
        ScopeData.Out oi = new ScopeData.Out();
        this.fillNameTarget(oi, out.value(), propertyName);
        oi.type = propertyType;
        return oi;
    }

    protected ScopeData.Out inspectOut(InOut inOut, ScopeType scopeType, String propertyName, Class propertyType) {
        if (inOut == null) {
            return null;
        }
        ScopeType scope = inOut.scope();
        if (scope != scopeType) {
            return null;
        }
        ScopeData.Out oi = new ScopeData.Out();
        this.fillNameTarget(oi, inOut.value(), propertyName);
        oi.type = propertyType;
        return oi;
    }

    protected ScopeData inspectScopeData(Class actionClass, ScopeType scopeType) {
        InOut inout;
        ScopeData.In ii;
        In in;
        ClassDescriptor cd = ClassIntrospector.lookup((Class)actionClass);
        FieldDescriptor[] fields = cd.getAllFieldDescriptors();
        MethodDescriptor[] methods = cd.getAllMethodDescriptors();
        ArrayList<ScopeData.In> listIn = new ArrayList<ScopeData.In>(fields.length + methods.length);
        ArrayList<ScopeData.Out> listOut = new ArrayList<ScopeData.Out>(fields.length + methods.length);
        for (FieldDescriptor fieldDescriptor : fields) {
            Out out;
            ScopeData.Out oi;
            Field field = fieldDescriptor.getField();
            Class fieldType = ReflectUtil.getRawType((Type)field.getGenericType(), (Class)actionClass);
            in = field.getAnnotation(In.class);
            ii = this.inspectIn(in, scopeType, field.getName(), fieldType);
            if (ii != null) {
                listIn.add(ii);
            }
            if ((inout = field.getAnnotation(InOut.class)) != null) {
                if (in != null) {
                    throw new MadvocException("InOut field annotation cannot be used together with In: " + field.getDeclaringClass() + '#' + field.getName());
                }
                ii = this.inspectIn(inout, scopeType, field.getName(), field.getType());
                if (ii != null) {
                    listIn.add(ii);
                }
            }
            if ((oi = this.inspectOut(out = field.getAnnotation(Out.class), scopeType, field.getName(), fieldType)) != null) {
                listOut.add(oi);
            }
            if ((inout = field.getAnnotation(InOut.class)) == null) continue;
            if (out != null) {
                throw new MadvocException("InOut field annotation cannot be used together with Out: " + field.getDeclaringClass() + '#' + field.getName());
            }
            oi = this.inspectOut(inout, scopeType, field.getName(), field.getType());
            if (oi == null) continue;
            listOut.add(oi);
        }
        for (FieldDescriptor fieldDescriptor : methods) {
            Method method = fieldDescriptor.getMethod();
            String propertyName = ReflectUtil.getBeanPropertySetterName((Method)method);
            if (propertyName != null) {
                in = method.getAnnotation(In.class);
                ii = this.inspectIn(in, scopeType, propertyName, method.getParameterTypes()[0]);
                if (ii != null) {
                    listIn.add(ii);
                }
                if ((inout = method.getAnnotation(InOut.class)) != null) {
                    if (in != null) {
                        throw new MadvocException("InOut method annotation cannot be used together with In: " + method.getDeclaringClass() + '#' + method.getName());
                    }
                    ii = this.inspectIn(inout, scopeType, propertyName, method.getParameterTypes()[0]);
                    if (ii != null) {
                        listIn.add(ii);
                    }
                }
            }
            if ((propertyName = ReflectUtil.getBeanPropertyGetterName((Method)method)) == null) continue;
            Out out = method.getAnnotation(Out.class);
            ScopeData.Out oi = this.inspectOut(out, scopeType, propertyName, method.getReturnType());
            if (oi != null) {
                listOut.add(oi);
            }
            if ((inout = method.getAnnotation(InOut.class)) == null) continue;
            if (out != null) {
                throw new MadvocException("InOut method annotation cannot be used together with Out: " + method.getDeclaringClass() + '#' + method.getName());
            }
            oi = this.inspectOut(inout, scopeType, propertyName, method.getReturnType());
            if (oi == null) continue;
            listOut.add(oi);
        }
        if (listIn.isEmpty() && listOut.isEmpty()) {
            return null;
        }
        ScopeData scopeData = new ScopeData();
        if (!listIn.isEmpty()) {
            scopeData.in = listIn.toArray(new ScopeData.In[listIn.size()]);
        }
        if (!listOut.isEmpty()) {
            scopeData.out = listOut.toArray(new ScopeData.Out[listOut.size()]);
        }
        return scopeData;
    }
}

