/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.HashMap;
import java.util.Map;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.MadvocContextInjector;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsManager {
    @PetiteInject
    protected MadvocContextInjector madvocContextInjector;
    protected final Map<String, ActionResult> results = new HashMap<String, ActionResult>();

    public Map<String, ActionResult> getAllActionResults() {
        return this.results;
    }

    public ActionResult register(Class<? extends ActionResult> resultClass) {
        return this.register(this.createResult(resultClass));
    }

    public ActionResult register(ActionResult result) {
        ActionResult existing = this.lookup(result.getType());
        if (existing != null) {
            Class<?> resultClass = result.getClass();
            if (!existing.getClass().equals(resultClass)) {
                throw new MadvocException("Madvoc result with the same result type '" + result.getType() + "' already registered: " + resultClass.getSimpleName());
            }
            result = existing;
        } else {
            this.results.put(result.getType(), result);
        }
        this.madvocContextInjector.injectMadvocContext(result);
        this.madvocContextInjector.injectMadvocParams(result);
        return result;
    }

    public ActionResult lookup(Class<? extends ActionResult> resultClass) {
        for (ActionResult actionResult : this.results.values()) {
            if (actionResult.getClass() != resultClass) continue;
            return actionResult;
        }
        return null;
    }

    public ActionResult lookup(String resultType) {
        return this.results.get(resultType);
    }

    protected ActionResult createResult(Class<? extends ActionResult> actionResultClass) {
        try {
            return actionResultClass.newInstance();
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to create Madvoc action result: " + actionResultClass, ex);
        }
    }
}

