/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionConfigSet;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.component.ActionPathMacroManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.macro.PathMacros;
import jodd.petite.meta.PetiteInject;
import jodd.util.ClassLoaderUtil;
import jodd.util.StringUtil;
import jodd.util.collection.SortedArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsManager {
    private static final Logger log = LoggerFactory.getLogger(ActionsManager.class);
    @PetiteInject
    protected ActionMethodParser actionMethodParser;
    @PetiteInject
    protected ActionPathMacroManager actionPathMacroManager;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    protected int actionsCount;
    protected final HashMap<String, ActionConfigSet> map = new HashMap();
    protected final SortedArrayList<ActionConfigSet> list = new SortedArrayList((Comparator)new ActionConfigSetComparator());
    protected Map<String, String> pathAliases = new HashMap<String, String>();

    public List<ActionConfig> getAllActionConfigurations() {
        ArrayList<ActionConfig> all = new ArrayList<ActionConfig>(this.actionsCount);
        for (ActionConfigSet set : this.map.values()) {
            all.addAll(set.getActionConfigs());
        }
        for (ActionConfigSet set : this.list) {
            all.addAll(set.getActionConfigs());
        }
        return all;
    }

    public int getActionsCount() {
        return this.actionsCount;
    }

    public ActionConfig register(String actionSignature) {
        return this.register(actionSignature, null);
    }

    public ActionConfig register(String actionSignature, String actionPath) {
        Class actionClass;
        int ndx = actionSignature.indexOf(35);
        if (ndx == -1) {
            throw new MadvocException("Madvoc action signature syntax error: " + actionSignature);
        }
        String actionClassName = actionSignature.substring(0, ndx);
        String actionMethodName = actionSignature.substring(ndx + 1);
        try {
            actionClass = ClassLoaderUtil.loadClass((String)actionClassName);
        }
        catch (ClassNotFoundException cnfex) {
            throw new MadvocException("Madvoc action class not found: " + actionClassName, cnfex);
        }
        return this.register(actionClass, actionMethodName, actionPath);
    }

    public ActionConfig register(Class actionClass, String actionMethod) {
        return this.register(actionClass, actionMethod, null);
    }

    public ActionConfig register(Class actionClass, String actionMethod, String actionPath) {
        return this.registerAction(actionClass, actionMethod, actionPath);
    }

    public ActionConfig register(Class actionClass, Method actionMethod, String actionPath) {
        return this.registerAction(actionClass, actionMethod, actionPath);
    }

    public ActionConfig register(Class actionClass, Method actionMethod) {
        return this.registerAction(actionClass, actionMethod, null);
    }

    protected ActionConfig registerAction(Class actionClass, Method actionMethod, String actionPath) {
        ActionConfig actionConfig = this.actionMethodParser.parse(actionClass, actionMethod, actionPath);
        if (actionConfig == null) {
            return null;
        }
        return this.registerAction(actionConfig);
    }

    protected ActionConfig registerAction(Class actionClass, String actionMethodName, String actionPath) {
        ActionConfig actionConfig = this.actionMethodParser.parse(actionClass, actionMethodName, actionPath);
        if (actionConfig == null) {
            return null;
        }
        return this.registerAction(actionConfig);
    }

    public ActionConfig registerAction(ActionConfig actionConfig) {
        String actionPath = actionConfig.actionPath;
        if (log.isDebugEnabled()) {
            log.debug("Registering Madvoc action: " + actionConfig.actionPath + " to: " + actionConfig.actionClass.getName() + '#' + actionConfig.actionClassMethod.getName());
        }
        ActionConfigSet set = this.createActionConfigSet(actionConfig.actionPath);
        if (set.actionPathMacros != null) {
            int ndx = -1;
            for (int i = 0; i < this.list.size(); ++i) {
                if (!((ActionConfigSet)this.list.get((int)i)).actionPath.equals(actionPath)) continue;
                ndx = i;
                break;
            }
            if (ndx < 0) {
                this.list.add((Object)set);
            } else {
                set = (ActionConfigSet)this.list.get(ndx);
            }
        } else if (!this.map.containsKey(actionConfig.actionPath)) {
            this.map.put(actionConfig.actionPath, set);
        } else {
            set = this.map.get(actionConfig.actionPath);
        }
        boolean isDuplicate = set.add(actionConfig);
        if (this.madvocConfig.isDetectDuplicatePathsEnabled() && isDuplicate) {
            throw new MadvocException("Duplicate action path for " + actionConfig);
        }
        if (!isDuplicate) {
            ++this.actionsCount;
        }
        return actionConfig;
    }

    protected ActionConfigSet createActionConfigSet(String actionPath) {
        PathMacros pathMacros = this.actionPathMacroManager.buildActionPathMacros(actionPath);
        return new ActionConfigSet(actionPath, pathMacros);
    }

    public ActionConfig lookup(String actionPath, String method) {
        ActionConfig actionConfig;
        ActionConfigSet actionConfigSet = this.map.get(actionPath);
        if (actionConfigSet != null && (actionConfig = actionConfigSet.lookup(method)) != null) {
            return actionConfig;
        }
        int actionPathDeep = StringUtil.count((String)actionPath, (char)'/');
        int len = this.list.size();
        int lastMatched = -1;
        int maxMatchedChars = -1;
        for (int i = 0; i < len; ++i) {
            actionConfigSet = (ActionConfigSet)this.list.get(i);
            int deep = actionConfigSet.deep;
            if (deep < actionPathDeep) continue;
            if (deep > actionPathDeep) break;
            int matchedChars = actionConfigSet.actionPathMacros.match(actionPath);
            if (matchedChars == -1 || matchedChars <= maxMatchedChars) continue;
            maxMatchedChars = matchedChars;
            lastMatched = i;
        }
        if (lastMatched < 0) {
            return null;
        }
        ActionConfigSet set = (ActionConfigSet)this.list.get(lastMatched);
        return set.lookup(method);
    }

    public void registerPathAlias(String alias, String path) {
        this.pathAliases.put(alias, path);
    }

    public String lookupPathAlias(String alias) {
        return this.pathAliases.get(alias);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionConfigSetComparator
    implements Comparator<ActionConfigSet> {
        @Override
        public int compare(ActionConfigSet set1, ActionConfigSet set2) {
            int deep1 = set1.deep;
            int deep2 = set2.deep;
            if (deep1 == deep2) {
                return set1.actionPath.compareTo(set2.actionPath);
            }
            return deep1 - deep2;
        }
    }
}

