/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionPathMapper;
import jodd.madvoc.component.ActionPathRewriter;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ResultMapper;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.component.ServletContextInjector;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.servlet.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MadvocController {
    private static final Logger log = LoggerFactory.getLogger(MadvocController.class);
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ActionPathMapper actionPathMapper;
    @PetiteInject
    protected ActionPathRewriter actionPathRewriter;
    @PetiteInject
    protected InterceptorsManager interceptorsManager;
    @PetiteInject
    protected ServletContextInjector servletContextInjector;
    @PetiteInject
    protected ResultsManager resultsManager;
    @PetiteInject
    protected ResultMapper resultMapper;
    protected ServletContext applicationContext;

    public void init(ServletContext servletContext) {
        this.applicationContext = servletContext;
    }

    public ServletContext getApplicationContext() {
        return this.applicationContext;
    }

    public String invoke(String actionPath, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        ActionRequest actionRequest = null;
        boolean characterEncodingSet = false;
        while (actionPath != null) {
            String httpMethod;
            ActionConfig actionConfig;
            if (log.isDebugEnabled()) {
                log.debug("Action path: " + actionPath);
            }
            if ((actionConfig = this.resolveActionConfig(actionPath = this.actionPathRewriter.rewrite(servletRequest, actionPath, httpMethod = servletRequest.getMethod().toUpperCase()), httpMethod)) == null) {
                return actionPath;
            }
            if (log.isDebugEnabled()) {
                log.debug("Invoking action path '" + actionPath + "' using " + actionConfig.actionClass.getSimpleName());
            }
            if (!characterEncodingSet && this.madvocConfig.isApplyCharacterEncoding()) {
                String encoding = this.madvocConfig.getEncoding();
                if (encoding != null) {
                    servletRequest.setCharacterEncoding(this.madvocConfig.getEncoding());
                    servletResponse.setCharacterEncoding(this.madvocConfig.getEncoding());
                }
                characterEncodingSet = true;
            }
            Object action = this.createAction(actionConfig.actionClass);
            ActionRequest previousRequest = actionRequest;
            actionRequest = this.createActionRequest(actionPath, actionConfig, action, servletRequest, servletResponse);
            actionRequest.setPreviousActionRequest(previousRequest);
            this.invokeAndRender(actionRequest);
            actionPath = actionRequest.getNextActionPath();
        }
        return null;
    }

    protected void invokeAndRender(ActionRequest actionRequest) throws Exception {
        Object resultValueObject = actionRequest.invoke();
        this.render(actionRequest, resultValueObject);
    }

    public void render(ActionRequest actionRequest, Object resultObject) throws Exception {
        ActionResult result;
        int columnIndex;
        String resultValue = resultObject != null ? resultObject.toString() : null;
        String resultType = null;
        if (resultValue != null && (columnIndex = resultValue.indexOf(58)) != -1) {
            resultType = resultValue.substring(0, columnIndex);
            resultValue = resultValue.substring(columnIndex + 1);
        }
        if (resultType == null && (resultType = actionRequest.getActionConfig().getResultType()) == null) {
            resultType = this.madvocConfig.getDefaultResultType();
        }
        if ((result = this.resultsManager.lookup(resultType)) == null) {
            throw new MadvocException("Unable to find action result type: " + resultType);
        }
        if (!result.isInitialized()) {
            this.initializeResult(result, actionRequest);
        }
        if (this.madvocConfig.isPreventCaching()) {
            ServletUtil.preventCaching((HttpServletResponse)actionRequest.getHttpServletResponse());
        }
        String resultPath = this.resultMapper.resolveResultPath(actionRequest.getActionConfig(), resultValue);
        result.render(actionRequest, resultObject, resultValue, resultPath);
    }

    protected void initializeResult(ActionResult result, ActionRequest actionRequest) {
        HttpServletRequest httpServletRequest = actionRequest.getHttpServletRequest();
        HttpServletResponse httpServletResponse = actionRequest.getHttpServletResponse();
        this.servletContextInjector.injectContext(result, httpServletRequest, httpServletResponse);
        result.initialized();
        result.init();
    }

    protected ActionConfig resolveActionConfig(String actionPath, String httpMethod) {
        ActionConfig actionConfig = this.actionPathMapper.resolveActionConfig(actionPath, httpMethod);
        if (actionConfig != null && !actionConfig.initialized) {
            this.initializeActionConfig(actionConfig);
        }
        return actionConfig;
    }

    protected void initializeActionConfig(ActionConfig cfg) {
        Class<? extends ActionInterceptor>[] interceptorClasses = cfg.interceptorClasses;
        if (interceptorClasses == null) {
            interceptorClasses = this.madvocConfig.getDefaultInterceptors();
        }
        for (ActionInterceptor interceptor : cfg.interceptors = this.interceptorsManager.resolveAll(interceptorClasses)) {
            if (interceptor.isInitialized()) continue;
            this.initializeInterceptor(interceptor);
        }
        cfg.initialized();
    }

    protected void initializeInterceptor(ActionInterceptor interceptor) {
        this.servletContextInjector.injectContext(interceptor, this.applicationContext);
        interceptor.initialized();
        interceptor.init();
    }

    protected Object createAction(Class actionClass) {
        try {
            return actionClass.newInstance();
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to create Madvoc action.", ex);
        }
    }

    protected ActionRequest createActionRequest(String actionPath, ActionConfig actionConfig, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        return new ActionRequest(actionPath, actionConfig, action, servletRequest, servletResponse);
    }
}

