/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.macro;

import jodd.madvoc.macro.PathMacro;
import jodd.util.StringUtil;

public abstract class BasePathMacro
implements PathMacro {
    protected final char SPLIT = (char)58;
    protected String prefix;
    protected String[] names;
    protected String pattern;
    protected String sufix;

    public boolean init(String chunk) {
        int[] ndx = StringUtil.indexOfRegion((String)chunk, (String)"${", (String)"}");
        if (ndx == null) {
            return false;
        }
        String name = chunk.substring(ndx[1], ndx[2]);
        int colonNdx = name.indexOf(58);
        String pattern = null;
        if (colonNdx != -1) {
            pattern = name.substring(colonNdx + 1).trim();
            name = name.substring(0, colonNdx).trim();
        }
        this.pattern = pattern;
        this.names = new String[]{name};
        this.prefix = ndx[0] == 0 ? "" : chunk.substring(0, ndx[0]);
        this.sufix = ndx[3] == chunk.length() ? "" : chunk.substring(ndx[3]);
        return true;
    }

    public String[] getNames() {
        return this.names;
    }

    public int match(String chunk) {
        String value;
        int matchedChars = 0;
        if (!chunk.startsWith(this.prefix)) {
            return -1;
        }
        matchedChars += this.prefix.length();
        if (!chunk.endsWith(this.sufix)) {
            return -1;
        }
        matchedChars += this.sufix.length();
        if (this.pattern != null && !this.matchValue(value = chunk.substring(this.prefix.length(), chunk.length() - this.sufix.length()))) {
            return -1;
        }
        return matchedChars;
    }

    protected abstract boolean matchValue(String var1);

    public String[] extract(String chunk) {
        int rightLen;
        int leftLen = this.prefix.length();
        if (leftLen + (rightLen = this.sufix.length()) > 0) {
            chunk = chunk.substring(leftLen, chunk.length() - rightLen);
        }
        return new String[]{chunk};
    }
}

