/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.MethodDescriptor;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.RootPackages;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.ActionAnnotation;
import jodd.madvoc.meta.ActionAnnotationData;
import jodd.madvoc.meta.FilteredBy;
import jodd.madvoc.meta.InterceptedBy;
import jodd.madvoc.meta.MadvocAction;
import jodd.petite.meta.PetiteInject;
import jodd.util.AnnotationDataReader;
import jodd.util.ClassLoaderUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMethodParser {
    protected static final String REPL_PACKAGE = "[package]";
    protected static final String REPL_CLASS = "[class]";
    protected static final String REPL_METHOD = "[method]";
    protected static final String REPL_EXTENSION = "[ext]";
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected InterceptorsManager interceptorsManager;
    @PetiteInject
    protected FiltersManager filtersManager;
    @PetiteInject
    protected MadvocConfig madvocConfig;

    public Method resolveActionMethod(Class<?> actionClass, String methodName) {
        MethodDescriptor methodDescriptor = ClassIntrospector.lookup(actionClass).getMethodDescriptor(methodName, false);
        if (methodDescriptor == null) {
            throw new MadvocException("Provided action class '" + actionClass.getSimpleName() + "' doesn't contain public method: " + methodName);
        }
        return methodDescriptor.getMethod();
    }

    public ActionConfig parse(Class<?> actionClass, Method actionMethod) {
        return this.parse(actionClass, actionMethod, null);
    }

    public ActionConfig parse(Class<?> actionClass, String actionMethodName, String actionPath) {
        Method method = this.resolveActionMethod(actionClass, actionMethodName);
        return this.parse(actionClass, method, actionPath);
    }

    public ActionConfig parse(Class<?> actionClass, Method actionMethod, String actionPath) {
        ActionAnnotation<?> actionAnnotation;
        ActionFilter[] actionFilters;
        Class[] filterClasses;
        ActionInterceptor[] actionInterceptors;
        Class[] interceptorClasses = this.readMethodInterceptors(actionMethod);
        if (interceptorClasses == null) {
            interceptorClasses = this.readClassInterceptors(actionClass);
        }
        if (interceptorClasses == null) {
            interceptorClasses = this.madvocConfig.getDefaultInterceptors();
        }
        if ((actionInterceptors = (ActionInterceptor[])this.interceptorsManager.resolveAll(interceptorClasses)) != null) {
            for (ActionInterceptor interceptor : actionInterceptors) {
                if (interceptor.isInitialized()) continue;
                this.interceptorsManager.initializeWrapper(interceptor);
            }
        }
        if ((filterClasses = this.readMethodFilters(actionMethod)) == null) {
            filterClasses = this.readClassFilters(actionClass);
        }
        if (filterClasses == null) {
            filterClasses = this.madvocConfig.getDefaultFilters();
        }
        if ((actionFilters = (ActionFilter[])this.filtersManager.resolveAll(filterClasses)) != null) {
            for (ActionFilter filter : actionFilters) {
                if (filter.isInitialized()) continue;
                this.filtersManager.initializeWrapper(filter);
            }
        }
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        String packageActionPath = this.readPackageActionPath(actionClass, replacementMap);
        String classActionPath = this.readClassActionPath(actionClass, replacementMap);
        if (classActionPath == null) {
            return null;
        }
        AnnotationDataReader.AnnotationData annotationData = null;
        ActionAnnotation<?>[] arr$ = this.madvocConfig.getActionAnnotationInstances();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (annotationData = (actionAnnotation = arr$[i$]).readAnnotationData(actionMethod)) == null; ++i$) {
        }
        String actionMethodName = actionMethod.getName();
        String methodActionPath = this.readMethodActionPath(actionMethodName, (ActionAnnotationData)annotationData, replacementMap);
        String extension = this.readMethodExtension((ActionAnnotationData)annotationData);
        String alias = this.readMethodAlias((ActionAnnotationData)annotationData);
        String httpMethod = this.readMethodHttpMethod((ActionAnnotationData)annotationData);
        String resultType = this.readResultType((ActionAnnotationData)annotationData);
        if (methodActionPath != null) {
            replacementMap.put(REPL_EXTENSION, extension);
            for (String path : this.madvocConfig.getDefaultActionMethodNames()) {
                if (!methodActionPath.equals(path)) continue;
                methodActionPath = null;
                break;
            }
        }
        if (actionPath == null) {
            actionPath = this.buildActionPath(packageActionPath, classActionPath, methodActionPath, extension, httpMethod);
        }
        for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
            actionPath = StringUtil.replace((String)actionPath, (String)entry.getKey(), (String)entry.getValue());
        }
        if (alias != null) {
            String aliasPath = StringUtil.cutToIndexOf((String)actionPath, (String)"#");
            this.actionsManager.registerPathAlias(alias, aliasPath);
        } else if (this.madvocConfig.isCreateDefaultAliases()) {
            alias = actionClass.getName() + '#' + actionMethod.getName();
            this.actionsManager.registerPathAlias(alias, actionPath);
        }
        return this.createActionConfig(actionClass, actionMethod, actionFilters, actionInterceptors, actionPath, httpMethod, extension, resultType);
    }

    protected String buildActionPath(String packageActionPath, String classActionPath, String methodActionPath, String extension, String httpMethod) {
        String pathSeparator = "/";
        String actionPath = classActionPath;
        if (methodActionPath != null) {
            if (methodActionPath.startsWith(pathSeparator)) {
                return methodActionPath;
            }
            if (extension != null) {
                methodActionPath = methodActionPath + '.' + extension;
            }
            if (!classActionPath.endsWith(pathSeparator)) {
                actionPath = actionPath + ".";
            }
            actionPath = actionPath + methodActionPath;
        } else if (extension != null) {
            actionPath = actionPath + '.' + extension;
        }
        if (actionPath.startsWith(pathSeparator)) {
            return actionPath;
        }
        actionPath = packageActionPath != null ? packageActionPath + actionPath : pathSeparator + actionPath;
        return actionPath;
    }

    protected Class<? extends ActionInterceptor>[] readClassInterceptors(Class actionClass) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionClass.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionInterceptor>[] readMethodInterceptors(Method actionMethod) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionMethod.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionFilter>[] readClassFilters(Class actionClass) {
        Class<? extends ActionFilter>[] result = null;
        FilteredBy filteredBy = actionClass.getAnnotation(FilteredBy.class);
        if (filteredBy != null && (result = filteredBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionFilter>[] readMethodFilters(Method actionMethod) {
        Class<? extends ActionFilter>[] result = null;
        FilteredBy filteredBy = actionMethod.getAnnotation(FilteredBy.class);
        if (filteredBy != null && (result = filteredBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected String readPackageActionPath(Class actionClass, Map<String, String> replacementMap) {
        MadvocAction madvocActionAnnotation;
        String packageActionPath;
        Package actionPackage = actionClass.getPackage();
        String actionPackageName = actionPackage.getName();
        RootPackages rootPackages = this.madvocConfig.getRootPackages();
        String packagePath = rootPackages.getPackageActionPath(actionPackageName);
        if (packagePath == null) {
            packagePath = rootPackages.findPackagePathForActionPackage(actionPackageName);
            String rootPackage = null;
            if (packagePath != null) {
                rootPackage = rootPackages.findRootPackageForActionPath(packagePath);
            }
            String packageName = actionPackageName;
            String madvocRootPackageClassName = this.madvocConfig.getMadvocRootPackageClassName();
            if (madvocRootPackageClassName != null) {
                while (true) {
                    String className = packageName + '.' + madvocRootPackageClassName;
                    try {
                        Class madvocRootPackageClass = ClassLoaderUtil.loadClass((String)className, (ClassLoader)actionClass.getClassLoader());
                        String mapping = "";
                        MadvocAction madvocAction = madvocRootPackageClass.getAnnotation(MadvocAction.class);
                        if (madvocAction != null) {
                            mapping = madvocAction.value();
                        }
                        this.madvocConfig.getRootPackages().addRootPackage(packageName, mapping);
                        packagePath = rootPackages.findPackagePathForActionPackage(actionPackageName);
                    }
                    catch (ClassNotFoundException ignore) {
                        int dotNdx = packageName.lastIndexOf(46);
                        if (dotNdx != -1) {
                            packageName = packageName.substring(0, dotNdx);
                            if (rootPackage == null || !packageName.equals(rootPackage)) continue;
                        }
                    }
                    break;
                }
            }
            rootPackages.registerPackageActionPath(actionPackageName, packagePath);
        }
        String string = packageActionPath = (madvocActionAnnotation = actionPackage.getAnnotation(MadvocAction.class)) != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty((String)packageActionPath)) {
            packageActionPath = null;
        }
        if (packageActionPath == null) {
            if (packagePath == null) {
                return null;
            }
            packageActionPath = packagePath;
        }
        replacementMap.put(REPL_PACKAGE, StringUtil.stripChar((String)packagePath, (char)'/'));
        return StringUtil.surround((String)packageActionPath, (String)"/");
    }

    protected String readClassActionPath(Class actionClass, Map<String, String> replacementMap) {
        String classActionPath;
        MadvocAction madvocActionAnnotation = actionClass.getAnnotation(MadvocAction.class);
        String string = classActionPath = madvocActionAnnotation != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty((String)classActionPath)) {
            classActionPath = null;
        }
        String name = actionClass.getSimpleName();
        name = StringUtil.uncapitalize((String)name);
        name = MadvocUtil.stripLastCamelWord(name);
        if (classActionPath == null) {
            classActionPath = name;
        }
        replacementMap.put(REPL_CLASS, name);
        return classActionPath;
    }

    protected String readMethodActionPath(String methodName, ActionAnnotationData annotationData, Map<String, String> replacementMap) {
        String methodActionPath;
        String string = methodActionPath = annotationData != null ? annotationData.getValue() : null;
        if (methodActionPath == null) {
            methodActionPath = methodName;
        } else if (methodActionPath.equals("#")) {
            return null;
        }
        replacementMap.put(REPL_METHOD, methodName);
        return methodActionPath;
    }

    protected String readMethodExtension(ActionAnnotationData annotationData) {
        String annExtension;
        String extension = this.madvocConfig.getDefaultExtension();
        if (annotationData != null && (annExtension = annotationData.getExtension()) != null) {
            extension = annExtension.equals("#") ? null : StringUtil.replace((String)annExtension, (String)REPL_EXTENSION, (String)extension);
        }
        return extension;
    }

    protected String readMethodAlias(ActionAnnotationData annotationData) {
        String alias = null;
        if (annotationData != null) {
            alias = annotationData.getAlias();
        }
        return alias;
    }

    private String readMethodHttpMethod(ActionAnnotationData annotationData) {
        String method = null;
        if (annotationData != null) {
            method = annotationData.getMethod();
        }
        return method;
    }

    private String readResultType(ActionAnnotationData annotationData) {
        String resultType = null;
        if (annotationData != null) {
            resultType = annotationData.getResult();
        }
        return resultType;
    }

    public ActionConfig createActionConfig(Class actionClass, Method actionClassMethod, ActionFilter[] filters, ActionInterceptor[] interceptors, String actionPath, String actionMethod, String actionPathExtension, String resultType) {
        return new ActionConfig(actionClass, actionClassMethod, filters, interceptors, actionPath, actionMethod, actionPathExtension, resultType);
    }
}

