/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.exception.ExceptionUtil;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;

public class ActionRequest {
    protected final MadvocController madvocController;
    protected final ActionConfig config;
    protected final String actionPath;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected Object[] params;
    protected final int totalInterceptors;
    protected int interceptorIndex;
    protected int filterIndex;
    protected int totalFilters;
    protected int execState;
    protected Object action;
    protected String nextActionPath;
    protected ActionRequest previousActionRequest;

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        this.servletResponse = response;
    }

    public ActionConfig getActionConfig() {
        return this.config;
    }

    public Object getAction() {
        return this.action;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public String getNextActionPath() {
        return this.nextActionPath;
    }

    public void setNextActionPath(String nextActionPath) {
        this.nextActionPath = nextActionPath;
    }

    public ActionRequest getPreviousActionRequest() {
        return this.previousActionRequest;
    }

    public void setPreviousActionRequest(ActionRequest previousActionRequest) {
        this.previousActionRequest = previousActionRequest;
    }

    public void setActionParams(Object[] params) {
        this.params = params;
    }

    public ActionRequest(MadvocController madvocController, String actionPath, ActionConfig config, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.madvocController = madvocController;
        this.actionPath = actionPath;
        this.config = config;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.totalInterceptors = this.config.interceptors != null ? this.config.interceptors.length : 0;
        this.interceptorIndex = 0;
        this.totalFilters = this.config.filters != null ? this.config.filters.length : 0;
        this.filterIndex = 0;
        this.execState = 0;
        this.action = action;
    }

    public Object invoke() throws Exception {
        if (this.execState >= 2) {
            throw new MadvocException("Action already invoked: " + this.config.actionPath);
        }
        if (this.execState == 0 && this.filterIndex < this.totalFilters) {
            ActionFilter filter = this.config.filters[this.filterIndex];
            ++this.filterIndex;
            return filter.invoke(this);
        }
        this.execState = 1;
        Object actionResult = this.invokeAction();
        if (this.execState == 2) {
            if (this.interceptorIndex > 0) {
                --this.interceptorIndex;
            } else {
                this.madvocController.render(this, actionResult);
                this.execState = 3;
            }
        }
        return actionResult;
    }

    protected Object invokeAction() throws Exception {
        if (this.interceptorIndex < this.totalInterceptors) {
            ActionInterceptor interceptor = this.config.interceptors[this.interceptorIndex];
            ++this.interceptorIndex;
            return interceptor.invoke(this);
        }
        this.execState = 2;
        return this.invokeActionMethod();
    }

    protected Object invokeActionMethod() throws Exception {
        try {
            return this.config.actionClassMethod.invoke(this.action, this.params);
        }
        catch (InvocationTargetException itex) {
            throw ExceptionUtil.extractTargetException((InvocationTargetException)itex);
        }
    }
}

