/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import jodd.chalk.Chalk256;
import jodd.joy.JoyBase;
import jodd.joy.JoyPetite;
import jodd.joy.JoyProps;
import jodd.joy.JoyProxetta;
import jodd.joy.JoyScanner;
import jodd.joy.Print;
import jodd.joy.madvoc.JoyActionConfig;
import jodd.joy.madvoc.JoyRestActionConfig;
import jodd.madvoc.AutomagicMadvocConfigurator;
import jodd.madvoc.WebApp;
import jodd.madvoc.component.ActionConfigManager;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.meta.Action;
import jodd.madvoc.meta.RestAction;
import jodd.madvoc.petite.PetiteWebApp;
import jodd.madvoc.proxetta.ProxettaAwareActionsManager;
import jodd.madvoc.proxetta.ProxettaSupplier;
import jodd.props.Props;
import jodd.proxetta.ProxettaUtil;
import jodd.util.ClassUtil;
import jodd.util.Consumers;

public class JoyMadvoc
extends JoyBase {
    private final Supplier<String> appNameSupplier;
    private final Supplier<JoyProxetta> joyProxettaSupplier;
    private final Supplier<JoyPetite> joyPetiteSupplier;
    private final Supplier<JoyScanner> joyScannerSupplier;
    private final Supplier<JoyProps> joyPropsSupplier;
    private final Consumers<WebApp> webAppConsumers;
    private ServletContext servletContext;
    private PetiteWebApp webApp;
    private Supplier<PetiteWebApp> webAppSupplier;

    public JoyMadvoc(Supplier<String> appNameSupplier, Supplier<JoyPetite> joyPetiteSupplier, Supplier<JoyProxetta> joyProxettaSupplier, Supplier<JoyProps> joyPropsSupplier, Supplier<JoyScanner> joyScannerSupplier) {
        this.appNameSupplier = appNameSupplier;
        this.joyProxettaSupplier = joyProxettaSupplier;
        this.joyPetiteSupplier = joyPetiteSupplier;
        this.joyScannerSupplier = joyScannerSupplier;
        this.joyPropsSupplier = joyPropsSupplier;
        this.webAppConsumers = Consumers.empty();
    }

    public void setWebAppSupplier(Supplier<PetiteWebApp> webAppSupplier) {
        this.webAppSupplier = webAppSupplier;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void add(Consumer<WebApp> webAppConsumer) {
        this.webAppConsumers.add(webAppConsumer);
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    @Override
    public void start() {
        this.initLogger();
        this.log.info("MADVOC start  ----------");
        this.webApp = this.webAppSupplier == null ? new PetiteWebApp(this.joyPetiteSupplier.get().getPetiteContainer()) : this.webAppSupplier.get();
        this.webApp.withRegisteredComponent(ActionConfigManager.class, acm -> {
            acm.bindAnnotationConfig(Action.class, JoyActionConfig.class);
            acm.bindAnnotationConfig(RestAction.class, JoyRestActionConfig.class);
        });
        if (this.servletContext != null) {
            this.webApp.bindServletContext(this.servletContext);
        }
        Props allProps = this.joyPropsSupplier.get().getProps();
        this.webApp.withParams(allProps.innerMap(this.beanNamePrefix()));
        this.webApp.registerComponent((Object)new ProxettaSupplier(this.joyProxettaSupplier.get().getProxetta()));
        this.webApp.registerComponent(ProxettaAwareActionsManager.class);
        AutomagicMadvocConfigurator automagicMadvocConfigurator = new AutomagicMadvocConfigurator(this.joyScannerSupplier.get().getClassScanner()){

            protected String createInfoMessage() {
                return "Scanning completed in " + this.elapsed + "ms.";
            }
        };
        this.webApp.registerComponent((Object)automagicMadvocConfigurator);
        this.webAppConsumers.accept((Object)this.webApp);
        this.webApp.start();
        this.log.info("MADVOC OK!");
    }

    protected String beanNamePrefix() {
        String appName = this.appNameSupplier.get();
        return appName + ".madvoc.";
    }

    @Override
    public void stop() {
        if (this.log != null) {
            this.log.info("MADVOC stop  ----------");
        }
        if (this.webApp != null) {
            this.webApp.shutdown();
        }
        this.webApp = null;
    }

    protected void printRoutes(int width) {
        ActionsManager actionsManager = (ActionsManager)this.webApp.madvocContainer().lookupComponent(ActionsManager.class);
        List actions = actionsManager.getAllActionRuntimes();
        Map aliases = actionsManager.getAllAliases();
        if (actions.isEmpty()) {
            return;
        }
        Print print = new Print();
        print.line("Routes", width);
        actions.stream().sorted(Comparator.comparing(actionRuntime -> actionRuntime.getActionPath() + ' ' + actionRuntime.getActionMethod())).forEach(ar -> {
            String actionMethod = ar.getActionMethod();
            print.out((Chalk256)Chalk256.chalk().yellow(), actionMethod == null ? "*" : actionMethod, 7);
            print.space();
            String signature = ClassUtil.getShortClassName((Class)ProxettaUtil.resolveTargetClass((Class)ar.getActionClass()), (int)2) + '#' + ar.getActionClassMethod().getName();
            print.outLeftRightNewLine((Chalk256)Chalk256.chalk().green(), ar.getActionPath(), (Chalk256)Chalk256.chalk().blue(), signature, width - 7 - 1);
        });
        if (!aliases.isEmpty()) {
            print.line("Aliases", width);
            actions.stream().sorted(Comparator.comparing(actionRuntime -> actionRuntime.getActionPath() + ' ' + actionRuntime.getActionMethod())).forEach(ar -> {
                String actionPath = ar.getActionPath();
                for (Map.Entry entry : aliases.entrySet()) {
                    if (!((String)entry.getValue()).equals(actionPath)) continue;
                    print.space(8);
                    print.outLeftRightNewLine((Chalk256)Chalk256.chalk().green(), (String)entry.getValue(), (Chalk256)Chalk256.chalk().blue(), (String)entry.getKey(), width - 8);
                }
            });
        }
        print.line(width);
    }
}

