/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import jodd.chalk.Chalk256;
import jodd.util.StringUtil;

public class Print {
    public void line(int width) {
        System.out.println(StringUtil.repeat((char)'-', (int)width));
    }

    public void line(String name, int width) {
        int len = name.length() + 2;
        System.out.print(StringUtil.repeat((char)'-', (int)1));
        System.out.print('[');
        System.out.print(((Chalk256)Chalk256.chalk().bold()).on(name));
        System.out.print(']');
        System.out.println(StringUtil.repeat((char)'-', (int)(width - len - 1)));
    }

    public void newLine() {
        System.out.println();
    }

    public void space() {
        System.out.print(' ');
    }

    public void space(int count) {
        while (count-- > 0) {
            System.out.print(' ');
        }
    }

    public void out(Chalk256 chalk256, String string) {
        System.out.print(chalk256.on(string));
    }

    public void out(Chalk256 chalk256, String string, int maxLen) {
        System.out.print(chalk256.on(Print.alignLeftAndPad(string, maxLen)));
    }

    public void outLeftRightNewLine(Chalk256 chalk256Left, String stringLeft, Chalk256 chalk256Right, String stringRight, int width) {
        int availWidth;
        int rightLen;
        int leftLen = stringLeft.length();
        int delta = leftLen + (rightLen = stringRight.length()) - (availWidth = width - 1);
        if (delta > 0) {
            if (stringRight.length() >= delta + 3) {
                stringRight = stringRight.substring(delta + 3);
                stringRight = "..." + stringRight;
            } else {
                stringRight = "";
            }
        }
        this.out(chalk256Left, stringLeft);
        this.space();
        while (delta++ < 0) {
            this.space();
        }
        this.out(chalk256Right, stringRight);
        this.newLine();
    }

    private static String alignLeftAndPad(String text, int size) {
        int textLength = text.length();
        if (textLength > size) {
            return text.substring(0, size);
        }
        StringBuilder sb = new StringBuilder(size);
        sb.append(text);
        while (textLength++ < size) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

