/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.auth;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jodd.servlet.ServletUtil;

public class UserSession<T> {
    private static final String AUTH_SESSION_NAME = UserSession.class.getName();
    private static final String AUTH_COOKIE_NAME = "JODD_JOY_SESSION";
    protected int cookieMaxAge = 1209600;
    private T authToken;
    private String authTokenValue;

    public static UserSession get(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return null;
        }
        return (UserSession)httpSession.getAttribute(AUTH_SESSION_NAME);
    }

    public static void stop(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        Cookie cookie;
        HttpSession httpSession = servletRequest.getSession(false);
        if (httpSession != null) {
            httpSession.removeAttribute(AUTH_SESSION_NAME);
        }
        if ((cookie = ServletUtil.getCookie((HttpServletRequest)servletRequest, (String)AUTH_COOKIE_NAME)) == null) {
            return;
        }
        cookie.setMaxAge(0);
        cookie.setPath("/");
        servletResponse.addCookie(cookie);
    }

    public void start(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        httpSession.setAttribute(AUTH_SESSION_NAME, (Object)this);
        Cookie cookie = new Cookie(AUTH_COOKIE_NAME, this.authTokenValue);
        cookie.setMaxAge(this.cookieMaxAge);
        cookie.setPath("/");
        httpServletResponse.addCookie(cookie);
    }

    public UserSession(T authToken, String authTokenValue) {
        this.authToken = authToken;
        this.authTokenValue = authTokenValue;
    }

    public T getAuthToken() {
        return this.authToken;
    }
}

