/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.vtor;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jodd.bean.BeanTemplateParser;
import jodd.joy.i18n.LocalizationUtil;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.Violation;

public class VtorUtil {
    private static BeanTemplateParser beanTemplateParser = new BeanTemplateParser();

    public static String createViolationsJsonString(HttpServletRequest request, List<Violation> violations) {
        if (violations == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append('[');
        int violationsSize = violations.size();
        for (int i = 0; i < violationsSize; ++i) {
            Violation violation = violations.get(i);
            if (i != 0) {
                sb.append(',');
            }
            sb.append('{');
            sb.append("\"name\":\"").append(violation.getName()).append('\"').append(',');
            sb.append("\"msg\":\"").append(VtorUtil.resolveValidationMessage(request, violation)).append('\"');
            sb.append('}');
        }
        sb.append(']');
        return sb.toString();
    }

    public static String resolveValidationMessage(HttpServletRequest request, Violation violation) {
        ValidationConstraint vc = violation.getConstraint();
        String key = vc != null ? vc.getClass().getName() : violation.getName();
        String msg = LocalizationUtil.findMessage(request, key);
        if (msg != null) {
            return beanTemplateParser.parseWithBean(msg, (Object)violation);
        }
        return null;
    }
}

