/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.i18n;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.util.ResourceBundleMessageResolver;

public class LocalizationUtil {
    private static final Logger log = LoggerFactory.getLogger(LocalizationUtil.class);
    public static final ResourceBundleMessageResolver MESSAGE_RESOLVER = new ResourceBundleMessageResolver(){

        public ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader classLoader) {
            if (!this.isCacheResourceBundles()) {
                LocalizationUtil.clearResourceBundleCache();
                LocalizationUtil.clearTomcatCache();
            }
            return super.getBundle(bundleName, locale, classLoader);
        }
    };
    public static final String REQUEST_BUNDLE_NAME_ATTR;
    public static final String SESSION_LOCALE_ATTR;

    public static void setRequestBundleName(ServletRequest request, String bundleName) {
        if (log.isDebugEnabled()) {
            log.debug("Bundle name for this request: " + bundleName);
        }
        request.setAttribute(REQUEST_BUNDLE_NAME_ATTR, (Object)bundleName);
    }

    public static void setSessionLocale(HttpSession session, String localeCode) {
        if (log.isDebugEnabled()) {
            log.debug("Locale stored to session: " + localeCode);
        }
        Locale locale = Locale.forLanguageTag(localeCode);
        session.setAttribute(SESSION_LOCALE_ATTR, (Object)locale);
    }

    public static Locale getSessionLocale(HttpSession session) {
        Locale locale = (Locale)session.getAttribute(SESSION_LOCALE_ATTR);
        return locale == null ? MESSAGE_RESOLVER.getFallbackLocale() : locale;
    }

    public static String findMessage(HttpServletRequest request, String key) {
        String bundleName = (String)request.getAttribute(REQUEST_BUNDLE_NAME_ATTR);
        Locale locale = (Locale)request.getSession().getAttribute(SESSION_LOCALE_ATTR);
        return MESSAGE_RESOLVER.findMessage(bundleName, locale, key);
    }

    public static String findMessage(String bundleName, HttpServletRequest request, String key) {
        Locale locale = (Locale)request.getSession().getAttribute(SESSION_LOCALE_ATTR);
        return MESSAGE_RESOLVER.findMessage(bundleName, locale, key);
    }

    public static String findMessage(HttpServletRequest request, Locale locale, String key) {
        String bundleName = (String)request.getAttribute(REQUEST_BUNDLE_NAME_ATTR);
        return MESSAGE_RESOLVER.findMessage(bundleName, locale, key);
    }

    public static String findDefaultMessage(HttpServletRequest request, String key) {
        Locale locale = (Locale)request.getSession().getAttribute(SESSION_LOCALE_ATTR);
        return MESSAGE_RESOLVER.findDefaultMessage(locale, key);
    }

    public String findMessage(String bundleName, Locale locale, String key) {
        return MESSAGE_RESOLVER.findMessage(bundleName, locale, key);
    }

    public static String findDefaultMessage(Locale locale, String key) {
        return MESSAGE_RESOLVER.findDefaultMessage(locale, key);
    }

    protected static void clearTomcatCache() {
        block5: {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = loader.getClass();
            try {
                if ("org.apache.catalina.loader.WebappClassLoader".equals(cl.getName())) {
                    LocalizationUtil.clearMap(cl, loader, "resourceEntries");
                } else if (log.isDebugEnabled()) {
                    log.debug("Class loader " + cl.getName() + " is not a Tomcat loader");
                }
            }
            catch (Exception ex) {
                if (!log.isWarnEnabled()) break block5;
                log.warn("Unable to clear Tomcat cache", (Throwable)ex);
            }
        }
    }

    protected static void clearResourceBundleCache() {
        try {
            LocalizationUtil.clearMap(ResourceBundle.class, null, "cacheList");
        }
        catch (Exception ex) {
            log.warn("Unable to clear resource bundle cache", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearMap(Class mapClass, Object map, String fieldName) throws Exception {
        Object cache;
        Field field = mapClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        Object object = cache = field.get(map);
        synchronized (object) {
            Class<?> ccl = cache.getClass();
            Method clearMethod = ccl.getMethod("clear", new Class[0]);
            clearMethod.invoke(cache, new Object[0]);
        }
    }

    static {
        MESSAGE_RESOLVER.addDefaultBundle("messages");
        MESSAGE_RESOLVER.addDefaultBundle("validation");
        REQUEST_BUNDLE_NAME_ATTR = ResourceBundleMessageResolver.class.getName() + ".BUNDLE.";
        SESSION_LOCALE_ATTR = ResourceBundleMessageResolver.class.getName() + ".LOCALE.";
    }
}

