/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import jodd.joy.JoyBase;
import jodd.props.Props;
import jodd.props.PropsUtil;

public class JoyProps
extends JoyBase {
    protected final Supplier<String> nameSupplier;
    protected Props props;
    private String propsNamePattern;
    private List<String> propsProfiles = new ArrayList<String>();

    public JoyProps(Supplier<String> nameSupplier) {
        this.nameSupplier = nameSupplier;
    }

    public Props getProps() {
        return this.props;
    }

    public JoyProps setPropsNamePattern(String namePattern) {
        this.propsNamePattern = namePattern;
        return this;
    }

    public JoyProps addPropsProfiles(String ... profiles) {
        Collections.addAll(this.propsProfiles, profiles);
        return this;
    }

    @Override
    void start() {
        this.initLogger();
        this.log.info("PROPS start ----------");
        this.props = this.createProps();
        this.props.loadSystemProperties("sys");
        this.props.loadEnvironment("env");
        this.log.info("Loaded sys&env props: " + this.props.countTotalProperties() + " propertes.");
        this.props.setActiveProfiles(this.propsProfiles.toArray(new String[0]));
        String namePattern = this.propsNamePattern;
        if (namePattern == null) {
            namePattern = "/" + this.nameSupplier.get() + "*.prop*";
        }
        this.log.debug("Loading props from classpath: " + namePattern);
        PropsUtil.loadFromClasspath((Props)this.props, (String[])new String[]{namePattern});
        this.log.info("Props is ready: " + this.props.countTotalProperties() + " propertes.");
    }

    protected Props createProps() {
        Props props = new Props();
        props.setSkipEmptyProps(true);
        props.setIgnoreMissingMacros(true);
        return props;
    }

    @Override
    void stop() {
        this.props = null;
    }
}

