/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jodd.db.DbDetector;
import jodd.db.DbSessionProvider;
import jodd.db.JoddDb;
import jodd.db.connection.ConnectionProvider;
import jodd.db.jtx.DbJtxSessionProvider;
import jodd.db.jtx.DbJtxTransactionManager;
import jodd.db.oom.AutomagicDbOomConfigurator;
import jodd.db.oom.DbEntityManager;
import jodd.db.pool.CoreConnectionPool;
import jodd.io.findfile.ClassScanner;
import jodd.joy.JoyBase;
import jodd.joy.JoyScanner;
import jodd.jtx.JoddJtx;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.proxy.AnnotationTxAdviceManager;
import jodd.jtx.proxy.AnnotationTxAdviceSupport;
import jodd.petite.PetiteContainer;
import jodd.util.Consumers;

public class JoyDb
extends JoyBase {
    protected final Supplier<JoyScanner> joyScannerSupplier;
    protected final Supplier<PetiteContainer> petiteContainerSupplier;
    protected ConnectionProvider connectionProvider;
    protected JtxTransactionManager jtxManager;
    protected String jtxScopePattern;
    private boolean databaseEnabled = true;
    private boolean autoConfiguration = true;
    private Supplier<ConnectionProvider> connectionProviderSupplier;
    private Consumers<DbEntityManager> dbEntityManagerConsumers = Consumers.empty();

    public JoyDb(Supplier<PetiteContainer> petiteContainerSupplier, Supplier<JoyScanner> joyScannerSupplier) {
        this.joyScannerSupplier = joyScannerSupplier;
        this.petiteContainerSupplier = petiteContainerSupplier;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public JtxTransactionManager getJtxManager() {
        return this.jtxManager;
    }

    public JoyDb disableDatabase() {
        this.databaseEnabled = false;
        return this;
    }

    public JoyDb disableAutoConfiguration() {
        this.autoConfiguration = false;
        return this;
    }

    public JoyDb withEntityManager(Consumer<DbEntityManager> dbEntityManagerConsumer) {
        this.dbEntityManagerConsumers.add(dbEntityManagerConsumer);
        return this;
    }

    public JoyDb withConnectionProvider(Supplier<ConnectionProvider> connectionProviderSupplier) {
        this.connectionProviderSupplier = connectionProviderSupplier;
        return this;
    }

    public boolean isDatabaseEnabled() {
        return this.databaseEnabled;
    }

    @Override
    void start() {
        CoreConnectionPool pool;
        this.initLogger();
        if (!this.databaseEnabled) {
            this.log.info("DB not enabled.");
            return;
        }
        this.log.info("DB start ----------");
        this.connectionProvider = this.createConnectionProviderIfNotSupplied();
        this.petiteContainerSupplier.get().addBean("dbpool", (Object)this.connectionProvider);
        if (this.connectionProvider instanceof CoreConnectionPool && (pool = (CoreConnectionPool)this.connectionProvider).getDriver() == null) {
            this.databaseEnabled = false;
            this.log.warn("DB configuration not set. DB will be disabled.");
            return;
        }
        this.connectionProvider.init();
        this.checkConnectionProvider();
        DbDetector.detectDatabaseAndConfigureDbOom((ConnectionProvider)this.connectionProvider);
        this.jtxManager = this.createJtxTransactionManager(this.connectionProvider);
        this.jtxManager.setValidateExistingTransaction(true);
        AnnotationTxAdviceManager annTxAdviceManager = new AnnotationTxAdviceManager(this.jtxManager, this.jtxScopePattern);
        annTxAdviceManager.registerAnnotations(JoddJtx.get().defaults().getTxAnnotations());
        AnnotationTxAdviceSupport.manager = annTxAdviceManager;
        DbJtxSessionProvider sessionProvider = new DbJtxSessionProvider(this.jtxManager);
        JoddDb.get().connectionProvider(this.connectionProvider);
        JoddDb.get().sessionProvider((DbSessionProvider)sessionProvider);
        this.petiteContainerSupplier.get().addBean("db", (Object)JoddDb.get().defaults());
        DbEntityManager dbEntityManager = JoddDb.get().dbEntityManager();
        dbEntityManager.reset();
        if (this.autoConfiguration) {
            this.registerDbEntities(dbEntityManager);
        }
        this.dbEntityManagerConsumers.accept((Object)dbEntityManager);
    }

    protected void registerDbEntities(DbEntityManager dbEntityManager) {
        AutomagicDbOomConfigurator dbcfg = new AutomagicDbOomConfigurator();
        dbcfg.withScanner(classScanner -> this.joyScannerSupplier.get().accept((ClassScanner)classScanner));
        this.log.info("*DB Automagic scanning");
        dbcfg.configure(dbEntityManager);
    }

    protected JtxTransactionManager createJtxTransactionManager(ConnectionProvider connectionProvider) {
        return new DbJtxTransactionManager(connectionProvider);
    }

    protected ConnectionProvider createConnectionProviderIfNotSupplied() {
        if (this.connectionProviderSupplier != null) {
            return this.connectionProviderSupplier.get();
        }
        return new CoreConnectionPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnectionProvider() {
        Connection connection = this.connectionProvider.getConnection();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String name = databaseMetaData.getDatabaseProductName();
            String version = databaseMetaData.getDatabaseProductVersion();
            if (this.log.isInfoEnabled()) {
                this.log.info("Connected to database: " + name + " v" + version);
            }
        }
        catch (SQLException sex) {
            this.log.error("DB connection failed: ", (Throwable)sex);
        }
        finally {
            this.connectionProvider.closeConnection(connection);
        }
    }

    @Override
    void stop() {
        if (!this.databaseEnabled) {
            return;
        }
        if (this.log != null) {
            this.log.info("DB stop");
        }
        if (this.jtxManager != null) {
            this.jtxManager.close();
        }
        if (this.connectionProvider != null) {
            this.connectionProvider.close();
        }
    }
}

