/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.auth;

import jodd.petite.meta.PetiteBean;
import jodd.util.crypt.BCrypt;

@PetiteBean
public class PasswordEncoder {
    protected int saltRounds = 12;

    public int getSaltRounds() {
        return this.saltRounds;
    }

    public void setSaltRounds(int saltRounds) {
        this.saltRounds = saltRounds;
    }

    public String encodePassword(String rawPassword) {
        if (rawPassword == null) {
            return null;
        }
        return BCrypt.hashpw((String)rawPassword, (String)BCrypt.gensalt((int)this.saltRounds));
    }

    public boolean isPasswordValid(String encodedPassword, String rawPassword) {
        return BCrypt.checkpw((String)rawPassword, (String)encodedPassword);
    }

    public static void main(String[] args) {
        PasswordEncoder passwordEncoder = new PasswordEncoder();
        if (args.length >= 1) {
            System.out.println(passwordEncoder.encodePassword(args[0]));
        }
    }
}

