/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy;

import java.util.function.Consumer;
import java.util.function.Supplier;
import jodd.io.findfile.ClassScanner;
import jodd.joy.JoyBase;
import jodd.joy.JoyScanner;
import jodd.petite.AutomagicPetiteConfigurator;
import jodd.petite.PetiteContainer;
import jodd.petite.proxetta.ProxettaAwarePetiteContainer;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SessionScope;
import jodd.petite.scope.SingletonScope;
import jodd.props.Props;
import jodd.proxetta.impl.ProxyProxetta;
import jodd.util.Consumers;

public class JoyPetite
extends JoyBase {
    protected final Supplier<JoyScanner> joyScannerSupplier;
    protected final Supplier<Props> propsSupplier;
    protected final Supplier<ProxyProxetta> proxettaSupplier;
    protected PetiteContainer petiteContainer;
    protected boolean isWebApplication = true;
    private boolean autoConfiguration = true;
    private Consumers<PetiteContainer> petiteContainerConsumers = Consumers.empty();

    public JoyPetite(Supplier<ProxyProxetta> proxettaSupplier, Supplier<Props> propsSupplier, Supplier<JoyScanner> joyScannerSupplier) {
        this.proxettaSupplier = proxettaSupplier;
        this.joyScannerSupplier = joyScannerSupplier;
        this.propsSupplier = propsSupplier;
    }

    public PetiteContainer getPetiteContainer() {
        return this.petiteContainer;
    }

    public JoyPetite disableAutoConfiguration() {
        this.autoConfiguration = false;
        return this;
    }

    public JoyPetite withPetite(Consumer<PetiteContainer> petiteContainerConsumer) {
        this.petiteContainerConsumers.add(petiteContainerConsumer);
        return this;
    }

    @Override
    void start() {
        this.initLogger();
        this.log.info("PETITE start  ----------");
        this.petiteContainer = this.createPetiteContainer();
        this.log.info("app in web: " + this.isWebApplication);
        if (!this.isWebApplication) {
            this.petiteContainer.registerScope(SessionScope.class, (Scope)new SingletonScope());
        }
        this.petiteContainer.defineParameters(this.propsSupplier.get());
        this.petiteContainer.addBean("scan", (Object)this.joyScannerSupplier.get());
        if (this.autoConfiguration) {
            this.log.info("*PETITE Automagic scanning");
            this.registerPetiteContainerBeans(this.petiteContainer);
        }
        this.log.debug("Petite manual configuration started...");
        this.petiteContainerConsumers.accept((Object)this.petiteContainer);
        this.petiteContainer.addBean("core", (Object)this.petiteContainer);
    }

    protected ProxettaAwarePetiteContainer createPetiteContainer() {
        return new ProxettaAwarePetiteContainer(this.proxettaSupplier.get());
    }

    protected void registerPetiteContainerBeans(PetiteContainer petiteContainer) {
        AutomagicPetiteConfigurator pcfg = new AutomagicPetiteConfigurator();
        pcfg.withScanner(classScanner -> this.joyScannerSupplier.get().accept((ClassScanner)classScanner));
        pcfg.configure(petiteContainer);
    }

    @Override
    void stop() {
        if (this.log != null) {
            this.log.info("PETITE stop");
        }
        if (this.petiteContainer != null) {
            this.petiteContainer.shutdown();
        }
    }
}

